/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.collection;

import io.camunda.zeebe.util.collection.Table;
import java.util.function.BiFunction;
import java.util.function.IntFunction;

final class EnumTable<RowT extends Enum<RowT>, ColT extends Enum<ColT>, T>
implements Table<RowT, ColT, T> {
    private final T[] items;
    private final int columnCount;

    EnumTable(Class<RowT> rowClass, Class<ColT> columnClass, IntFunction<T[]> arraySupplier) {
        int rowCount = ((Enum[])rowClass.getEnumConstants()).length;
        this.columnCount = ((Enum[])columnClass.getEnumConstants()).length;
        this.items = arraySupplier.apply(rowCount * this.columnCount);
    }

    @Override
    public T get(RowT rowKey, ColT columnKey) {
        int index = this.mapToIndex(rowKey, columnKey);
        return this.items[index];
    }

    @Override
    public void put(RowT rowKey, ColT columnKey, T value) {
        int index = this.mapToIndex(rowKey, columnKey);
        this.items[index] = value;
    }

    @Override
    public T computeIfAbsent(RowT rowKey, ColT columnKey, BiFunction<RowT, ColT, T> computer) {
        int index = this.mapToIndex(rowKey, columnKey);
        T value = this.items[index];
        if (value != null) {
            return value;
        }
        T updated = computer.apply(rowKey, columnKey);
        this.items[index] = updated;
        return updated;
    }

    private int mapToIndex(RowT firstPart, ColT secondPart) {
        return ((Enum)firstPart).ordinal() * this.columnCount + ((Enum)secondPart).ordinal();
    }
}

