/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.impl.SnapshotMetricsDoc;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.atomic.AtomicLong;

public final class SnapshotMetrics {
    private final AtomicLong snapshotChunkCount = new AtomicLong();
    private final AtomicLong snapshotSize = new AtomicLong();
    private final Clock clock;
    private final Timer snapshotPersistDuration;
    private final DistributionSummary snapshotFileSize;
    private final Timer snapshotDuration;
    private final Counter snapshotCount;

    public SnapshotMetrics(MeterRegistry registry) {
        this.clock = registry.config().clock();
        this.snapshotDuration = MicrometerUtil.buildTimer((ExtendedMeterDocumentation)SnapshotMetricsDoc.SNAPSHOT_DURATION).register(registry);
        this.snapshotPersistDuration = MicrometerUtil.buildTimer((ExtendedMeterDocumentation)SnapshotMetricsDoc.SNAPSHOT_PERSIST_DURATION).register(registry);
        this.snapshotFileSize = MicrometerUtil.buildSummary((ExtendedMeterDocumentation)SnapshotMetricsDoc.SNAPSHOT_FILE_SIZE).register(registry);
        this.snapshotCount = Counter.builder((String)SnapshotMetricsDoc.SNAPSHOT_COUNT.getName()).description(SnapshotMetricsDoc.SNAPSHOT_COUNT.getDescription()).register(registry);
        Gauge.builder((String)SnapshotMetricsDoc.SNAPSHOT_CHUNK_COUNT.getName(), (Object)this.snapshotChunkCount, Number::longValue).description(SnapshotMetricsDoc.SNAPSHOT_CHUNK_COUNT.getDescription()).register(registry);
        Gauge.builder((String)SnapshotMetricsDoc.SNAPSHOT_SIZE.getName(), (Object)this.snapshotSize, Number::longValue).description(SnapshotMetricsDoc.SNAPSHOT_SIZE.getDescription()).register(registry);
    }

    void incrementSnapshotCount() {
        this.snapshotCount.increment();
    }

    void observeSnapshotSize(long sizeInBytes) {
        this.snapshotSize.set(sizeInBytes);
    }

    void observeSnapshotChunkCount(long count) {
        this.snapshotChunkCount.set(count);
    }

    void observeSnapshotFileSize(long sizeInBytes) {
        this.snapshotFileSize.record((double)((float)sizeInBytes / 1000000.0f));
    }

    CloseableSilently startTimer() {
        return MicrometerUtil.timer((Timer)this.snapshotDuration, (Timer.Sample)Timer.start((Clock)this.clock));
    }

    CloseableSilently startPersistTimer() {
        return MicrometerUtil.timer((Timer)this.snapshotPersistDuration, (Timer.Sample)Timer.start((Clock)this.clock));
    }
}

