/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.snapshots.ImmutableChecksumsSFV;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.SnapshotChunkReader;
import io.camunda.zeebe.snapshots.SnapshotException;
import io.camunda.zeebe.snapshots.SnapshotMetadata;
import io.camunda.zeebe.snapshots.SnapshotReservation;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotChunkReader;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotId;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotReservation;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileBasedSnapshot
implements PersistedSnapshot {
    private static final int VERSION = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedSnapshot.class);
    private final Path directory;
    private final Path checksumFile;
    private final ImmutableChecksumsSFV checksums;
    private final FileBasedSnapshotId snapshotId;
    private final SnapshotMetadata metadata;
    private final Consumer<FileBasedSnapshot> onSnapshotDeleted;
    private final Set<FileBasedSnapshotReservation> reservations = new HashSet<FileBasedSnapshotReservation>();
    private final ConcurrencyControl actor;
    private boolean deleted = false;

    FileBasedSnapshot(Path directory, Path checksumFile, ImmutableChecksumsSFV checksums, FileBasedSnapshotId snapshotId, SnapshotMetadata metadata, Consumer<FileBasedSnapshot> onSnapshotDeleted, ConcurrencyControl actor) {
        this.directory = directory;
        this.checksumFile = checksumFile;
        this.checksums = checksums;
        this.snapshotId = snapshotId;
        this.metadata = metadata;
        this.onSnapshotDeleted = onSnapshotDeleted;
        this.actor = actor;
    }

    public FileBasedSnapshotId getSnapshotId() {
        return this.snapshotId;
    }

    public Path getDirectory() {
        return this.directory;
    }

    @Override
    public int version() {
        return 1;
    }

    @Override
    public long getIndex() {
        return this.snapshotId.getIndex();
    }

    @Override
    public long getTerm() {
        return this.snapshotId.getTerm();
    }

    @Override
    public SnapshotChunkReader newChunkReader() {
        try {
            return new FileBasedSnapshotChunkReader(this.directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Path getPath() {
        return this.getDirectory();
    }

    @Override
    public Path getChecksumPath() {
        return this.checksumFile;
    }

    @Override
    public long getCompactionBound() {
        return this.getIndex();
    }

    @Override
    public String getId() {
        return this.snapshotId.getSnapshotIdAsString();
    }

    @Override
    public ImmutableChecksumsSFV getChecksums() {
        return this.checksums;
    }

    @Override
    public SnapshotMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public ActorFuture<SnapshotReservation> reserve() {
        CompletableActorFuture snapshotLocked = new CompletableActorFuture();
        this.actor.run(() -> {
            if (!this.deleted) {
                FileBasedSnapshotReservation reservation = new FileBasedSnapshotReservation(this);
                this.reservations.add(reservation);
                snapshotLocked.complete((Object)reservation);
            } else {
                snapshotLocked.completeExceptionally((Throwable)new SnapshotException.SnapshotNotFoundException(String.format("Expected to reserve snapshot %s, but snapshot is deleted.", this.getId())));
            }
        });
        return snapshotLocked;
    }

    @Override
    public boolean isReserved() {
        return !this.reservations.isEmpty();
    }

    void delete() {
        try {
            Files.deleteIfExists(this.checksumFile);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete snapshot checksum file {}", (Object)this.checksumFile, (Object)e);
        }
        try {
            FileUtil.deleteFolderIfExists((Path)this.directory);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete snapshot {}", (Object)this.directory, (Object)e);
        }
        this.deleted = true;
        this.onSnapshotDeleted.accept(this);
    }

    public int hashCode() {
        int result = this.getDirectory().hashCode();
        result = 31 * result + this.checksumFile.hashCode();
        result = 31 * result + this.getSnapshotId().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileBasedSnapshot that = (FileBasedSnapshot)o;
        if (!this.getChecksums().sameChecksums(that.getChecksums())) {
            return false;
        }
        if (!this.getDirectory().equals(that.getDirectory())) {
            return false;
        }
        if (!this.checksumFile.equals(that.checksumFile)) {
            return false;
        }
        return this.getSnapshotId().equals(that.getSnapshotId());
    }

    public String toString() {
        return "FileBasedSnapshot{directory=" + String.valueOf(this.directory) + ", checksumFile=" + String.valueOf(this.checksumFile) + ", snapshotId=" + String.valueOf(this.snapshotId) + ", metadata=" + String.valueOf(this.metadata) + "}";
    }

    ActorFuture<Void> removeReservation(FileBasedSnapshotReservation reservation) {
        return this.actor.call(() -> {
            this.reservations.remove(reservation);
            return null;
        });
    }
}

