/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

public enum ActorMetricsDoc implements ExtendedMeterDocumentation
{
    EXECUTION_LATENCY{
        private static final Duration[] TIMER_SLOS = MicrometerUtil.exponentialBucketDuration((long)100L, (long)4L, (int)10, (TemporalUnit)ChronoUnit.MICROS);

        public String getName() {
            return "zeebe.actor.task.execution.latency";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getDescription() {
            return "Execution time of a certain actor task";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{ActorMetricsKeyName.ACTOR_NAME};
        }

        public Duration[] getTimerSLOs() {
            return TIMER_SLOS;
        }
    }
    ,
    SCHEDULING_LATENCY{
        private static final Duration[] TIMER_SLOS = MicrometerUtil.exponentialBucketDuration((long)1L, (long)4L, (int)12, (TemporalUnit)ChronoUnit.MICROS);

        public String getName() {
            return "zeebe.actor.job.scheduling.latency";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getDescription() {
            return "Time between scheduling and executing a job";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{ActorMetricsKeyName.SUBSCRIPTION_TYPE};
        }

        public Duration[] getTimerSLOs() {
            return TIMER_SLOS;
        }
    }
    ,
    EXECUTION_COUNT{

        public String getName() {
            return "zeebe.actor_task_execution_count";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public String getDescription() {
            return "Number of times a certain actor task was executed successfully";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{ActorMetricsKeyName.ACTOR_NAME};
        }
    }
    ,
    JOB_QUEUE_LENGTH{

        public String getName() {
            return "zeebe.actor.task.queue.length";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public String getDescription() {
            return "The length of the job queue for an actor task";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{ActorMetricsKeyName.ACTOR_NAME};
        }
    };


    public static enum ActorMetricsKeyName implements KeyName
    {
        SUBSCRIPTION_TYPE{

            public String asString() {
                return "subscriptionType";
            }
        }
        ,
        ACTOR_NAME{

            public String asString() {
                return "actorName";
            }
        };

    }
}

