/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorFutureSubscription;
import io.camunda.zeebe.scheduler.ActorMetrics;
import io.camunda.zeebe.scheduler.ActorSubscription;
import io.camunda.zeebe.scheduler.ActorTask;
import io.camunda.zeebe.scheduler.ActorThread;
import io.camunda.zeebe.scheduler.TimerSubscription;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Loggers;
import io.camunda.zeebe.util.error.FatalErrorHandler;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.Async;
import org.slf4j.Logger;

public final class ActorJob {
    private static final Logger LOG = Loggers.ACTOR_LOGGER;
    private static final FatalErrorHandler FATAL_ERROR_HANDLER = FatalErrorHandler.withLogger((Logger)LOG);
    ActorTask.TaskSchedulingState schedulingState;
    ActorTask task;
    private Callable<?> callable;
    private Runnable runnable;
    private ActorFuture resultFuture;
    private ActorSubscription subscription;
    private long scheduledAt = -1L;

    public void onJobAddedToTask(ActorTask task) {
        this.scheduledAt = System.nanoTime();
        this.task = task;
        this.schedulingState = ActorTask.TaskSchedulingState.QUEUED;
    }

    @Async.Execute
    void execute(ActorThread runner) {
        this.observeSchedulingLatency(runner.getActorMetrics());
        try {
            this.invoke();
        }
        catch (Throwable e) {
            FATAL_ERROR_HANDLER.handleError(e);
            this.task.onFailure(e);
        }
        finally {
            if (this.isTriggeredBySubscription() || this.runnable == null) {
                this.schedulingState = ActorTask.TaskSchedulingState.TERMINATED;
            } else {
                this.schedulingState = ActorTask.TaskSchedulingState.QUEUED;
                this.scheduledAt = System.nanoTime();
            }
        }
    }

    private void observeSchedulingLatency(ActorMetrics metrics) {
        if (metrics.isEnabled()) {
            ActorFutureSubscription s;
            long now = System.nanoTime();
            Object object = this.subscription;
            if (object instanceof ActorFutureSubscription && (object = (s = (ActorFutureSubscription)object).getFuture()) instanceof CompletableActorFuture) {
                CompletableActorFuture f = (CompletableActorFuture)object;
                long subscriptionCompleted = f.getCompletedAt();
                metrics.observeJobSchedulingLatency(now - subscriptionCompleted, ActorMetrics.SubscriptionType.FUTURE);
            } else {
                ActorSubscription subscriptionCompleted = this.subscription;
                if (subscriptionCompleted instanceof TimerSubscription) {
                    TimerSubscription s2 = (TimerSubscription)subscriptionCompleted;
                    long timerExpired = s2.getTimerExpiredAt();
                    metrics.observeJobSchedulingLatency(now - timerExpired, ActorMetrics.SubscriptionType.TIMER);
                } else if (this.subscription == null && this.scheduledAt != -1L) {
                    metrics.observeJobSchedulingLatency(now - this.scheduledAt, ActorMetrics.SubscriptionType.NONE);
                }
            }
        }
    }

    private void invoke() throws Exception {
        Object invocationResult;
        if (this.callable != null) {
            invocationResult = this.callable.call();
        } else {
            invocationResult = null;
            if (!this.isTriggeredBySubscription()) {
                Runnable r = this.runnable;
                this.runnable = null;
                r.run();
            } else {
                this.runnable.run();
            }
        }
        if (this.resultFuture != null) {
            this.resultFuture.complete(invocationResult);
            this.resultFuture = null;
        }
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public ActorFuture setCallable(Callable<?> callable) {
        this.callable = callable;
        this.setResultFuture(new CompletableActorFuture());
        return this.resultFuture;
    }

    void reset() {
        this.schedulingState = ActorTask.TaskSchedulingState.NOT_SCHEDULED;
        this.scheduledAt = -1L;
        this.task = null;
        this.callable = null;
        this.runnable = null;
        this.resultFuture = null;
        this.subscription = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ActorJob{");
        sb.append("schedulingState=").append((Object)this.schedulingState);
        sb.append(", task=").append(this.task);
        if (this.callable != null) {
            sb.append(", callable=").append(this.callable);
        }
        if (this.runnable != null) {
            sb.append(", runnable=").append(this.runnable);
        }
        if (this.resultFuture != null) {
            sb.append(", resultFuture=").append(this.resultFuture);
        }
        if (this.subscription != null) {
            sb.append(", subscription=").append(this.subscription);
        }
        if (this.scheduledAt != -1L) {
            sb.append(", scheduledAt=").append(this.scheduledAt);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean isTriggeredBySubscription() {
        return this.subscription != null;
    }

    public ActorSubscription getSubscription() {
        return this.subscription;
    }

    public void setSubscription(ActorSubscription subscription) {
        this.subscription = subscription;
        this.task.addSubscription(subscription);
    }

    public ActorTask getTask() {
        return this.task;
    }

    public Actor getActor() {
        return this.task.actor;
    }

    public void setResultFuture(ActorFuture resultFuture) {
        assert (!resultFuture.isDone());
        this.resultFuture = resultFuture;
    }

    public void failFuture(String reason) {
        this.failFuture(new RuntimeException(reason));
    }

    public void failFuture(Throwable cause) {
        if (this.resultFuture != null) {
            this.resultFuture.completeExceptionally(cause);
        }
    }
}

