/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.testing;

import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.ScheduledTimer;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.TestActorFuture;
import io.camunda.zeebe.util.LockUtil;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class TestConcurrencyControl
implements ConcurrencyControl {
    private final ReentrantLock lock = new ReentrantLock();

    public <T> void runOnCompletion(ActorFuture<T> future, BiConsumer<T, Throwable> callback) {
        future.onComplete(callback);
    }

    public <T> void runOnCompletion(Collection<ActorFuture<T>> actorFutures, Consumer<Throwable> callback) {
        if (actorFutures.isEmpty()) {
            callback.accept(null);
            return;
        }
        AtomicReference error = new AtomicReference();
        AtomicInteger futuresCompleted = new AtomicInteger(actorFutures.size());
        TestActorFuture<Object> finalFuture = new TestActorFuture<Object>();
        for (ActorFuture<T> f : actorFutures) {
            f.onComplete((r, e) -> {
                if (e != null) {
                    error.set(e);
                }
                if (futuresCompleted.decrementAndGet() == 0) {
                    if (error.get() != null) {
                        finalFuture.completeExceptionally((Throwable)error.get());
                    } else {
                        finalFuture.complete(null);
                    }
                }
            });
        }
        finalFuture.onComplete((ignore, throwable) -> callback.accept((Throwable)throwable));
    }

    public void run(Runnable action) {
        LockUtil.withLock((Lock)this.lock, (Runnable)action);
    }

    public <T> ActorFuture<T> call(Callable<T> callable) {
        Object call;
        try {
            call = LockUtil.withLock((Lock)this.lock, callable);
        }
        catch (Exception e) {
            return TestActorFuture.failedFuture(e);
        }
        return TestActorFuture.completedFuture(call);
    }

    public ScheduledTimer schedule(Duration delay, Runnable runnable) {
        LockUtil.withLock((Lock)this.lock, (Runnable)runnable);
        return () -> {};
    }

    public <V> ActorFuture<V> createFuture() {
        return new TestActorFuture();
    }

    public <V> ActorFuture<V> createCompletedFuture() {
        return this.completedFuture(null);
    }

    public <U> ActorFuture<U> completedFuture(U value) {
        ActorFuture result = this.createFuture();
        result.complete(value);
        return result;
    }

    public <U> ActorFuture<U> failedFuture(Throwable error) {
        ActorFuture result = this.createFuture();
        result.completeExceptionally(error);
        return result;
    }
}

