/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.testing;

import io.camunda.zeebe.scheduler.ActorTask;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.agrona.LangUtil;

public final class TestActorFuture<V>
implements ActorFuture<V> {
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final List<BiConsumer<V, Throwable>> onCompleteCallbacks = new ArrayList<BiConsumer<V, Throwable>>();
    private Either<Throwable, V> result;

    public void complete(V value) {
        this.result = Either.right(value);
        this.countDownLatch.countDown();
        this.triggerOnCompleteListeners();
    }

    public void completeExceptionally(String failure, Throwable throwable) {
        this.completeExceptionally(throwable);
    }

    public void completeExceptionally(Throwable throwable) {
        this.result = Either.left((Object)throwable);
        this.countDownLatch.countDown();
        this.triggerOnCompleteListeners();
    }

    public V join() {
        try {
            return this.get();
        }
        catch (Throwable t) {
            LangUtil.rethrowUnchecked((Throwable)t);
            return null;
        }
    }

    public V join(long timeout, TimeUnit timeUnit) {
        try {
            return this.get(timeout, timeUnit);
        }
        catch (Throwable t) {
            LangUtil.rethrowUnchecked((Throwable)t);
            return null;
        }
    }

    public void block(ActorTask onCompletion) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void onComplete(BiConsumer<V, Throwable> consumer) {
        this.onCompleteCallbacks.add(consumer);
        if (this.isDone()) {
            this.triggerOnCompleteListener(consumer);
        }
    }

    public void onComplete(BiConsumer<V, Throwable> consumer, Executor executor) {
        this.onComplete((res, error) -> executor.execute(() -> consumer.accept((Object)res, (Throwable)error)));
    }

    public boolean isCompletedExceptionally() {
        return this.result != null && this.result.isLeft();
    }

    public Throwable getException() {
        return this.result != null && this.result.isLeft() ? (Throwable)this.result.getLeft() : null;
    }

    public <U> ActorFuture<U> andThen(Supplier<ActorFuture<U>> next, Executor executor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <U> ActorFuture<U> andThen(Function<V, ActorFuture<U>> next, Executor executor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <U> ActorFuture<U> thenApply(Function<V, U> next, Executor executor) {
        TestActorFuture nextFuture = new TestActorFuture();
        this.onComplete((value, error) -> {
            if (error != null) {
                nextFuture.completeExceptionally((Throwable)error);
                return;
            }
            try {
                nextFuture.complete(next.apply(value));
            }
            catch (Exception e) {
                nextFuture.completeExceptionally(new CompletionException(e));
            }
        }, executor);
        return nextFuture;
    }

    private void triggerOnCompleteListeners() {
        this.onCompleteCallbacks.forEach(this::triggerOnCompleteListener);
    }

    private void triggerOnCompleteListener(BiConsumer<V, Throwable> consumer) {
        this.result.ifRightOrLeft(value -> consumer.accept(value, null), error -> consumer.accept((Object)null, (Throwable)error));
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean isCancelled() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean isDone() {
        return this.result != null;
    }

    public V get() throws InterruptedException, ExecutionException {
        this.countDownLatch.await();
        if (this.result.isRight()) {
            return (V)this.result.get();
        }
        throw new ExecutionException((Throwable)this.result.getLeft());
    }

    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.countDownLatch.await(timeout, unit);
        return this.get();
    }

    public static <U> ActorFuture<U> completedFuture(U value) {
        TestActorFuture<U> result = new TestActorFuture<U>();
        result.complete(value);
        return result;
    }

    public static <U> ActorFuture<U> failedFuture(Throwable error) {
        TestActorFuture result = new TestActorFuture();
        result.completeExceptionally(error);
        return result;
    }
}

