/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.testing;

import io.camunda.zeebe.scheduler.ActorThread;
import io.camunda.zeebe.scheduler.ActorThreadGroup;
import io.camunda.zeebe.scheduler.ActorTimerQueue;
import io.camunda.zeebe.scheduler.TaskScheduler;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Phaser;
import org.agrona.concurrent.IdleStrategy;

public final class ControlledActorThread
extends ActorThread {
    private final Phaser phaser = new Phaser(2);

    public ControlledActorThread(String name, int id, ActorThreadGroup threadGroup, TaskScheduler taskScheduler, ActorClock clock, ActorTimerQueue timerQueue, IdleStrategy idleStrategy) {
        super(name, id, threadGroup, taskScheduler, clock, timerQueue, false, idleStrategy);
        this.idleStrategy = new ControlledIdleStrategy(idleStrategy);
    }

    public CompletableFuture<Void> close() {
        this.phaser.arriveAndDeregister();
        return super.close();
    }

    public void resumeTasks() {
        this.phaser.arriveAndAwaitAdvance();
    }

    public void waitUntilDone() {
        while (this.phaser.getArrivedParties() < 1) {
            Thread.yield();
        }
    }

    public void workUntilDone() {
        this.resumeTasks();
        this.waitUntilDone();
    }

    private final class ControlledIdleStrategy
    extends ActorThread.ActorTaskRunnerIdleStrategy {
        private ControlledIdleStrategy(IdleStrategy idleStrategy) {
            super((ActorThread)ControlledActorThread.this, idleStrategy);
        }

        protected void onIdle() {
            super.onIdle();
            ControlledActorThread.this.phaser.arriveAndAwaitAdvance();
        }
    }
}

