/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.testing;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorThread;
import io.camunda.zeebe.scheduler.ActorThreadGroup;
import io.camunda.zeebe.scheduler.ActorTimerQueue;
import io.camunda.zeebe.scheduler.TaskScheduler;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.clock.ControlledActorClock;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.testing.ControlledActorThread;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.agrona.concurrent.IdleStrategy;
import org.junit.rules.ExternalResource;

public final class ControlledActorSchedulerRule
extends ExternalResource {
    private final ActorScheduler actorScheduler;
    private final ControlledActorThread controlledActorTaskRunner;
    private final ControlledActorClock clock = new ControlledActorClock();

    public ControlledActorSchedulerRule() {
        ControlledActorThreadFactory actorTaskRunnerFactory = new ControlledActorThreadFactory();
        ActorTimerQueue timerQueue = new ActorTimerQueue((ActorClock)this.clock, 1);
        ActorScheduler.ActorSchedulerBuilder builder = ActorScheduler.newActorScheduler().setActorClock((ActorClock)this.clock).setCpuBoundActorThreadCount(1).setIoBoundActorThreadCount(0).setActorThreadFactory((ActorScheduler.ActorThreadFactory)actorTaskRunnerFactory).setActorTimerQueue(timerQueue);
        this.actorScheduler = builder.build();
        this.controlledActorTaskRunner = actorTaskRunnerFactory.controlledThread;
    }

    protected void before() {
        this.actorScheduler.start();
        this.controlledActorTaskRunner.waitUntilDone();
    }

    protected void after() {
        try {
            this.actorScheduler.stop().get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public ActorFuture<Void> submitActor(Actor actor) {
        return this.actorScheduler.submitActor(actor);
    }

    public ActorScheduler get() {
        return this.actorScheduler;
    }

    public void workUntilDone() {
        this.controlledActorTaskRunner.workUntilDone();
    }

    public <T> ActorFuture<T> call(Callable<T> callable) {
        CompletableActorFuture future = new CompletableActorFuture();
        this.submitActor(new CallingActor<T>(future, callable));
        return future;
    }

    public ControlledActorClock getClock() {
        return this.clock;
    }

    static final class ControlledActorThreadFactory
    implements ActorScheduler.ActorThreadFactory {
        private ControlledActorThread controlledThread;

        ControlledActorThreadFactory() {
        }

        public ActorThread newThread(String name, int id, ActorThreadGroup threadGroup, TaskScheduler taskScheduler, ActorClock clock, ActorTimerQueue timerQueue, boolean metricsEnabled, IdleStrategy idleStrategy) {
            this.controlledThread = new ControlledActorThread(name, id, threadGroup, taskScheduler, clock, timerQueue, idleStrategy);
            return this.controlledThread;
        }
    }

    static class CallingActor<T>
    extends Actor {
        private final ActorFuture<T> future;
        private final Callable<T> callable;

        CallingActor(ActorFuture<T> future, Callable<T> callable) {
            this.future = future;
            this.callable = callable;
        }

        protected void onActorStarted() {
            this.actor.run(() -> {
                try {
                    this.future.complete(this.callable.call());
                }
                catch (Exception e) {
                    this.future.completeExceptionally((Throwable)e);
                }
            });
        }
    }
}

