/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.testing;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorThread;
import io.camunda.zeebe.scheduler.ActorThreadGroup;
import io.camunda.zeebe.scheduler.ActorTimerQueue;
import io.camunda.zeebe.scheduler.TaskScheduler;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.clock.ControlledActorClock;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.ControlledActorThread;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import org.agrona.concurrent.IdleStrategy;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ControlledActorSchedulerExtension
implements BeforeEachCallback,
AfterEachCallback {
    private final Consumer<ActorScheduler.ActorSchedulerBuilder> configurator;
    private ActorScheduler actorScheduler;
    private ControlledActorThread controlledActorTaskRunner;
    private ControlledActorClock clock;

    public ControlledActorSchedulerExtension() {
        this(builder -> {});
    }

    public ControlledActorSchedulerExtension(Consumer<ActorScheduler.ActorSchedulerBuilder> configurator) {
        this.configurator = Objects.requireNonNull(configurator, "must specify a configurator");
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        this.actorScheduler.stop();
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        ControlledActorThreadFactory actorTaskRunnerFactory = new ControlledActorThreadFactory();
        this.clock = new ControlledActorClock();
        ActorTimerQueue timerQueue = new ActorTimerQueue((ActorClock)this.clock, 1);
        ActorScheduler.ActorSchedulerBuilder builder = ActorScheduler.newActorScheduler().setActorClock((ActorClock)this.clock).setCpuBoundActorThreadCount(1).setIoBoundActorThreadCount(0).setActorThreadFactory((ActorScheduler.ActorThreadFactory)actorTaskRunnerFactory).setActorTimerQueue(timerQueue);
        this.configurator.accept(builder);
        this.actorScheduler = builder.build();
        this.controlledActorTaskRunner = actorTaskRunnerFactory.controlledThread;
        this.actorScheduler.start();
        this.controlledActorTaskRunner.waitUntilDone();
    }

    public ActorFuture<Void> submitActor(Actor actor) {
        return this.actorScheduler.submitActor(actor);
    }

    public void workUntilDone() {
        this.controlledActorTaskRunner.workUntilDone();
    }

    public void resume() {
        this.controlledActorTaskRunner.resumeTasks();
    }

    public void updateClock(Duration duration) {
        this.clock.addTime(duration);
    }

    public void setClockTime(long currentTime) {
        this.clock.setCurrentTime(currentTime);
    }

    public ControlledActorClock getClock() {
        return this.clock;
    }

    static final class ControlledActorThreadFactory
    implements ActorScheduler.ActorThreadFactory {
        private ControlledActorThread controlledThread;

        ControlledActorThreadFactory() {
        }

        public ActorThread newThread(String name, int id, ActorThreadGroup threadGroup, TaskScheduler taskScheduler, ActorClock clock, ActorTimerQueue timerQueue, boolean metricsEnabled, IdleStrategy idleStrategy) {
            this.controlledThread = new ControlledActorThread(name, id, threadGroup, taskScheduler, clock, timerQueue, idleStrategy);
            return this.controlledThread;
        }
    }
}

