/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.testing;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import org.agrona.LangUtil;
import org.junit.rules.ExternalResource;

public final class ActorSchedulerRule
extends ExternalResource {
    private final int numOfIoThreads;
    private final int numOfThreads;
    private final ActorClock clock;
    private ActorScheduler.ActorSchedulerBuilder builder;
    private ActorScheduler actorScheduler;

    public ActorSchedulerRule(int numOfThreads, ActorClock clock) {
        this(numOfThreads, 2, clock);
    }

    public ActorSchedulerRule(int numOfThreads, int numOfIoThreads, ActorClock clock) {
        this.numOfIoThreads = numOfIoThreads;
        this.numOfThreads = numOfThreads;
        this.clock = clock;
    }

    public ActorSchedulerRule(int numOfThreads) {
        this(numOfThreads, null);
    }

    public ActorSchedulerRule(ActorClock clock) {
        this(Math.max(1, Runtime.getRuntime().availableProcessors() - 2), clock);
    }

    public ActorSchedulerRule() {
        this(null);
    }

    public void before() {
        this.builder = ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(this.numOfThreads).setIoBoundActorThreadCount(this.numOfIoThreads).setActorClock(this.clock);
        this.actorScheduler = this.builder.build();
        this.actorScheduler.start();
    }

    public void after() {
        try {
            this.actorScheduler.close();
        }
        catch (Exception e) {
            LangUtil.rethrowUnchecked((Throwable)e);
        }
        this.actorScheduler = null;
        this.builder = null;
    }

    public ActorFuture<Void> submitActor(Actor actor) {
        return this.actorScheduler.submitActor(actor);
    }

    public ActorScheduler get() {
        return this.actorScheduler;
    }

    public ActorScheduler.ActorSchedulerBuilder getBuilder() {
        return this.builder;
    }
}

