/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.retry;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.retry.EndlessRetryStrategy;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class EndlessRetryStrategyTest {
    @Rule
    public final ControlledActorSchedulerRule schedulerRule = new ControlledActorSchedulerRule();
    private EndlessRetryStrategy retryStrategy;
    private ActorControl actorControl;
    private ActorFuture<Boolean> resultFuture;

    @Before
    public void setUp() {
        ControllableActor actor = new ControllableActor(this);
        this.actorControl = actor.getActor();
        this.retryStrategy = new EndlessRetryStrategy(this.actorControl);
        this.schedulerRule.submitActor(actor);
    }

    @Test
    public void shouldRunUntilDone() throws Exception {
        AtomicInteger count = new AtomicInteger(0);
        this.actorControl.run(() -> {
            this.resultFuture = this.retryStrategy.runWithRetry(() -> count.incrementAndGet() == 10);
        });
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((int)count.get()).isEqualTo(10);
        Assertions.assertThat((boolean)this.resultFuture.isDone()).isTrue();
        Assertions.assertThat((Boolean)((Boolean)this.resultFuture.get())).isTrue();
    }

    @Test
    public void shouldStopWhenAbortConditionReturnsTrue() throws Exception {
        AtomicInteger count = new AtomicInteger(0);
        this.actorControl.run(() -> {
            this.resultFuture = this.retryStrategy.runWithRetry(() -> false, () -> count.incrementAndGet() == 10);
        });
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((int)count.get()).isEqualTo(10);
        Assertions.assertThat((boolean)this.resultFuture.isDone()).isTrue();
        Assertions.assertThat((Boolean)((Boolean)this.resultFuture.get())).isFalse();
    }

    @Test
    public void shouldRetryOnExceptionAndAbortWhenConditionReturnsTrue() throws Exception {
        AtomicInteger count = new AtomicInteger(0);
        this.actorControl.run(() -> {
            this.resultFuture = this.retryStrategy.runWithRetry(() -> {
                throw new RuntimeException();
            }, () -> count.incrementAndGet() == 10);
        });
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((int)count.get()).isEqualTo(10);
        Assertions.assertThat((boolean)this.resultFuture.isDone()).isTrue();
        Assertions.assertThat((Boolean)((Boolean)this.resultFuture.get())).isFalse();
    }

    @Test
    public void shouldRetryOnException() throws Exception {
        AtomicInteger count = new AtomicInteger(0);
        AtomicBoolean toggle = new AtomicBoolean(false);
        this.actorControl.run(() -> {
            this.resultFuture = this.retryStrategy.runWithRetry(() -> {
                toggle.set(!toggle.get());
                if (toggle.get()) {
                    throw new RuntimeException("expected");
                }
                return count.incrementAndGet() == 10;
            });
        });
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((int)count.get()).isEqualTo(10);
        Assertions.assertThat((boolean)this.resultFuture.isDone()).isTrue();
        Assertions.assertThat((Boolean)((Boolean)this.resultFuture.get())).isTrue();
    }

    private final class ControllableActor
    extends Actor {
        private ControllableActor(EndlessRetryStrategyTest endlessRetryStrategyTest) {
        }

        public ActorControl getActor() {
            return this.actor;
        }
    }
}

