/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.retry;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.retry.BackOffRetryStrategy;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class BackOffRetryStrategyTest {
    @Rule
    public final ControlledActorSchedulerRule schedulerRule = new ControlledActorSchedulerRule();
    private BackOffRetryStrategy retryStrategy;
    private ActorControl actorControl;
    private ActorFuture<Boolean> resultFuture;

    @Before
    public void setUp() {
        ControllableActor actor = new ControllableActor(this);
        this.actorControl = actor.getActor();
        this.retryStrategy = new BackOffRetryStrategy(this.actorControl, Duration.ofSeconds(10L));
        this.schedulerRule.submitActor(actor);
    }

    @Test
    public void shouldRunWithoutDelay() throws Exception {
        ArrayList callRecorder = new ArrayList();
        long startTime = this.schedulerRule.getClock().getCurrentTimeInMillis();
        this.actorControl.run(() -> {
            this.resultFuture = this.retryStrategy.runWithRetry(() -> {
                callRecorder.add(ActorClock.current().getTimeMillis());
                return true;
            });
        });
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((int)callRecorder.size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.resultFuture.isDone()).isTrue();
        Assertions.assertThat((Boolean)((Boolean)this.resultFuture.get())).isTrue();
        Assertions.assertThat((long)((Long)callRecorder.get(0) - startTime)).isLessThan(500L);
    }

    @Test
    public void shouldRunWithBackOff() throws Exception {
        AtomicInteger count = new AtomicInteger(0);
        ArrayList callRecorder = new ArrayList();
        this.actorControl.run(() -> {
            this.resultFuture = this.retryStrategy.runWithRetry(() -> {
                callRecorder.add(ActorClock.current().getTimeMillis());
                return count.incrementAndGet() == 10;
            });
        });
        while (count.get() != 10) {
            this.schedulerRule.workUntilDone();
            this.schedulerRule.getClock().addTime(Duration.ofSeconds(1L));
        }
        Assertions.assertThat((int)count.get()).isEqualTo(10);
        Assertions.assertThat((boolean)this.resultFuture.isDone()).isTrue();
        Assertions.assertThat((Boolean)((Boolean)this.resultFuture.get())).isTrue();
        long beforeLastCall = (Long)callRecorder.get(callRecorder.size() - 2);
        long lastCall = (Long)callRecorder.get(callRecorder.size() - 1);
        Assertions.assertThat((long)(lastCall - beforeLastCall)).isBetween(Long.valueOf(10000L), Long.valueOf(10500L));
    }

    @Test
    public void shouldStopWhenAbortConditionReturnsTrue() throws Exception {
        this.actorControl.run(() -> {
            this.resultFuture = this.retryStrategy.runWithRetry(() -> false, () -> true);
        });
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((boolean)this.resultFuture.isDone()).isTrue();
        Assertions.assertThat((Boolean)((Boolean)this.resultFuture.get())).isFalse();
    }

    @Test
    public void shouldRetryOnExceptionAndAbortWhenConditionReturnsTrue() throws Exception {
        AtomicInteger count = new AtomicInteger(0);
        this.actorControl.run(() -> {
            this.resultFuture = this.retryStrategy.runWithRetry(() -> {
                throw new RuntimeException();
            }, () -> count.incrementAndGet() == 2);
        });
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((int)count.get()).isEqualTo(1);
        Assertions.assertThat((boolean)this.resultFuture.isDone()).isFalse();
        this.schedulerRule.getClock().addTime(Duration.ofSeconds(2L));
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((int)count.get()).isEqualTo(2);
        Assertions.assertThat((boolean)this.resultFuture.isDone()).isTrue();
        Assertions.assertThat((Boolean)((Boolean)this.resultFuture.get())).isFalse();
    }

    @Test
    public void shouldRetryOnExceptionWithMaxBackOff() throws Exception {
        AtomicInteger count = new AtomicInteger(0);
        AtomicBoolean toggle = new AtomicBoolean(false);
        ArrayList callRecorder = new ArrayList();
        this.actorControl.run(() -> {
            this.resultFuture = this.retryStrategy.runWithRetry(() -> {
                callRecorder.add(ActorClock.current().getTimeMillis());
                toggle.set(!toggle.get());
                if (toggle.get()) {
                    throw new RuntimeException("expected");
                }
                return count.incrementAndGet() == 10;
            });
        });
        while (count.get() != 10) {
            this.schedulerRule.workUntilDone();
            this.schedulerRule.getClock().addTime(Duration.ofSeconds(1L));
        }
        Assertions.assertThat((int)count.get()).isEqualTo(10);
        Assertions.assertThat((boolean)this.resultFuture.isDone()).isTrue();
        Assertions.assertThat((Boolean)((Boolean)this.resultFuture.get())).isTrue();
        long beforeLastCall = (Long)callRecorder.get(callRecorder.size() - 2);
        long lastCall = (Long)callRecorder.get(callRecorder.size() - 1);
        Assertions.assertThat((long)(lastCall - beforeLastCall)).isBetween(Long.valueOf(10000L), Long.valueOf(10500L));
    }

    private final class ControllableActor
    extends Actor {
        private ControllableActor(BackOffRetryStrategyTest backOffRetryStrategyTest) {
        }

        public ActorControl getActor() {
            return this.actor;
        }
    }
}

