/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.ordering;

import io.camunda.zeebe.scheduler.ActorCondition;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.ordering.ActionRecordingActor;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import java.time.Duration;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.junit.Rule;
import org.junit.Test;

public final class RunnableOrderingTests {
    private static final String ONE = "one";
    private static final String TWO = "two";
    private static final String THREE = "three";
    private static final String FOUR = "four";
    private static final String FIVE = "five";
    @Rule
    public final ControlledActorSchedulerRule schedulerRule = new ControlledActorSchedulerRule();

    @Test
    public void shouldRunAllActionsInAnyOrder() {
        ActionRecordingActor actor = new ActionRecordingActor(this){

            protected void onActorStarted() {
                this.actor.run(this.runnable(RunnableOrderingTests.ONE));
                this.actor.run(this.runnable(RunnableOrderingTests.TWO));
                this.actor.run(this.runnable(RunnableOrderingTests.THREE));
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(actor.actions).containsOnly((Object[])new String[]{ONE, TWO, THREE});
    }

    @Test
    public void shouldFinishCurrentRunnableAfterExecutingNext() {
        ActionRecordingActor actor = new ActionRecordingActor(this){

            protected void onActorStarted() {
                this.actor.run(() -> {
                    this.actor.run(this.runnable(RunnableOrderingTests.TWO));
                    this.actions.add(RunnableOrderingTests.ONE);
                });
                this.actor.run(this.runnable(RunnableOrderingTests.THREE));
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(actor.actions).containsSequence((Iterable)Lists.newArrayList((Object[])new String[]{ONE, TWO}));
        Assertions.assertThat(actor.actions).containsOnly((Object[])new String[]{ONE, TWO, THREE});
    }

    @Test
    public void submitTest() {
        ActionRecordingActor actor = new ActionRecordingActor(this){

            protected void onActorStarted() {
                this.actor.run(() -> {
                    this.actor.submit(this.runnable(RunnableOrderingTests.TWO));
                    this.actions.add(RunnableOrderingTests.ONE);
                });
                this.actor.run(this.runnable(RunnableOrderingTests.THREE));
                this.actor.submit(this.runnable(RunnableOrderingTests.FOUR));
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{ONE, TWO}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{THREE, TWO}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{ONE, FOUR}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{THREE, FOUR}));
    }

    @Test
    public void runOnCompletionFutureTest() {
        final CompletableActorFuture future = CompletableActorFuture.completed(null);
        ActionRecordingActor actor = new ActionRecordingActor(this){

            protected void onActorStarted() {
                this.actor.run(() -> {
                    this.actor.runOnCompletion((ActorFuture)future, this.futureConsumer(RunnableOrderingTests.TWO));
                    this.actions.add(RunnableOrderingTests.ONE);
                });
                this.actor.run(this.runnable(RunnableOrderingTests.THREE));
                this.actor.runOnCompletion((ActorFuture)future, this.futureConsumer(RunnableOrderingTests.FOUR));
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{ONE, TWO}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{THREE, TWO}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{ONE, FOUR}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{THREE, FOUR}));
    }

    @Test
    public void blockPhaseUntilCompletionFutureTest() {
        final CompletableActorFuture future = CompletableActorFuture.completed(null);
        ActionRecordingActor actor = new ActionRecordingActor(this){

            protected void onActorStarted() {
                this.actor.run(() -> {
                    this.actor.runOnCompletionBlockingCurrentPhase((ActorFuture)future, this.futureConsumer(RunnableOrderingTests.TWO));
                    this.actions.add(RunnableOrderingTests.ONE);
                });
                this.actor.run(this.runnable(RunnableOrderingTests.THREE));
                this.actor.runOnCompletionBlockingCurrentPhase((ActorFuture)future, this.futureConsumer(RunnableOrderingTests.FOUR));
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{ONE, TWO}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{THREE, TWO}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{ONE, FOUR}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{THREE, FOUR}));
    }

    @Test
    public void conditionTest() {
        final CompletableActorFuture conditionFuture = new CompletableActorFuture();
        ActionRecordingActor actor = new ActionRecordingActor(this){

            protected void onActorStarted() {
                this.actor.run(() -> {
                    ActorCondition condition = this.actor.onCondition("cond", () -> {
                        this.actions.add(RunnableOrderingTests.THREE);
                        this.actor.run(this.runnable(RunnableOrderingTests.FOUR));
                    });
                    conditionFuture.complete((Object)condition);
                    this.actions.add(RunnableOrderingTests.ONE);
                });
                this.actor.run(this.runnable(RunnableOrderingTests.TWO));
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ActorCondition condition = (ActorCondition)conditionFuture.join();
        condition.signal();
        condition.signal();
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(actor.actions).containsSequence((Iterable)Lists.newArrayList((Object[])new String[]{THREE, FOUR, THREE, FOUR}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{ONE, THREE}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{TWO, THREE}));
    }

    @Test
    public void timerTest() {
        this.schedulerRule.getClock().setCurrentTime(100L);
        ActionRecordingActor actor = new ActionRecordingActor(this){

            protected void onActorStarted() {
                this.actor.run(() -> {
                    this.actor.runAtFixedRate(Duration.ofMillis(10L), () -> {
                        this.actions.add(RunnableOrderingTests.THREE);
                        this.actor.run(this.runnable(RunnableOrderingTests.FOUR));
                    });
                    this.actions.add(RunnableOrderingTests.ONE);
                });
                this.actor.run(this.runnable(RunnableOrderingTests.TWO));
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        this.schedulerRule.getClock().addTime(Duration.ofMillis(10L));
        this.schedulerRule.workUntilDone();
        this.schedulerRule.getClock().addTime(Duration.ofMillis(10L));
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(actor.actions).containsSequence((Iterable)Lists.newArrayList((Object[])new String[]{THREE, FOUR, THREE, FOUR}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{ONE, THREE}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{TWO, THREE}));
    }

    @Test
    public void callTest() {
        final CompletableActorFuture future = new CompletableActorFuture();
        ActionRecordingActor actor = new ActionRecordingActor(this){

            protected void onActorStarted() {
                this.actor.run(() -> {
                    this.actor.runOnCompletion((ActorFuture)future, (v, t) -> {
                        this.actions.add(RunnableOrderingTests.THREE);
                        this.actor.run(this.runnable(RunnableOrderingTests.FOUR));
                    });
                    this.actions.add(RunnableOrderingTests.ONE);
                });
                this.actor.run(this.runnable(RunnableOrderingTests.TWO));
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.actorControl().call(() -> actor.actions.add(FIVE));
        future.complete(null);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(actor.actions).containsSequence((Iterable)Lists.newArrayList((Object[])new String[]{THREE, FOUR}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{ONE, THREE}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{TWO, THREE}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{ONE, FIVE}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{TWO, FIVE}));
    }

    @Test
    public void callWithBlockingPhaseTest() {
        final CompletableActorFuture future = new CompletableActorFuture();
        ActionRecordingActor actor = new ActionRecordingActor(this){

            protected void onActorStarted() {
                this.actor.run(() -> {
                    this.actor.runOnCompletionBlockingCurrentPhase((ActorFuture)future, (v, t) -> {
                        this.actions.add(RunnableOrderingTests.THREE);
                        this.actor.run(this.runnable(RunnableOrderingTests.FOUR));
                    });
                    this.actions.add(RunnableOrderingTests.ONE);
                });
                this.actor.run(this.runnable(RunnableOrderingTests.TWO));
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.actorControl().call(() -> actor.actions.add(FIVE));
        future.complete(null);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(actor.actions).containsSequence((Iterable)Lists.newArrayList((Object[])new String[]{THREE, FOUR}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{ONE, THREE}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{TWO, THREE}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{ONE, FIVE}));
        Assertions.assertThat(actor.actions).containsSubsequence((Iterable)Lists.newArrayList((Object[])new String[]{TWO, FIVE}));
    }
}

