/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.lifecycle;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.ActorTask;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.assertj.core.util.Lists;

class LifecycleRecordingActor
extends Actor {
    public static final List<ActorTask.ActorLifecyclePhase> FULL_LIFECYCLE = Lists.newArrayList((Object[])new ActorTask.ActorLifecyclePhase[]{ActorTask.ActorLifecyclePhase.STARTING, ActorTask.ActorLifecyclePhase.STARTED, ActorTask.ActorLifecyclePhase.CLOSE_REQUESTED, ActorTask.ActorLifecyclePhase.CLOSING, ActorTask.ActorLifecyclePhase.CLOSED});
    private static final BiConsumer<Void, Throwable> NOOP_CONSUMER = (ok, err) -> {};
    public final List<ActorTask.ActorLifecyclePhase> phases = new ArrayList<ActorTask.ActorLifecyclePhase>();

    LifecycleRecordingActor() {
    }

    public void onActorStarting() {
        this.phases.add(this.actor.getLifecyclePhase());
    }

    public void onActorStarted() {
        this.phases.add(this.actor.getLifecyclePhase());
    }

    public void onActorClosing() {
        this.phases.add(this.actor.getLifecyclePhase());
    }

    public void onActorClosed() {
        this.phases.add(this.actor.getLifecyclePhase());
    }

    public void onActorCloseRequested() {
        this.phases.add(this.actor.getLifecyclePhase());
    }

    public void onActorFailed() {
        this.phases.add(this.actor.getLifecyclePhase());
    }

    protected void blockPhase() {
        this.blockPhase((ActorFuture<Void>)new CompletableActorFuture(), NOOP_CONSUMER);
    }

    protected void blockPhase(ActorFuture<Void> future) {
        this.blockPhase(future, NOOP_CONSUMER);
    }

    protected void blockPhase(ActorFuture<Void> future, BiConsumer<Void, Throwable> consumer) {
        this.actor.runOnCompletionBlockingCurrentPhase(future, consumer);
    }

    protected void runOnCompletion() {
        this.actor.runOnCompletion((ActorFuture)new CompletableActorFuture(), NOOP_CONSUMER);
    }

    protected void runOnCompletion(ActorFuture<Void> future) {
        this.actor.runOnCompletion(future, NOOP_CONSUMER);
    }

    public ActorControl control() {
        return this.actor;
    }
}

