/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.lifecycle;

import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.lifecycle.LifecycleRecordingActor;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public final class ActorRecyclingTest {
    @Rule
    public final ControlledActorSchedulerRule schedulerRule = new ControlledActorSchedulerRule();

    @Test
    public void shouldPerformFullLifecycleAfterRecycle() {
        LifecycleRecordingActor actor = new LifecycleRecordingActor();
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        actor.phases.clear();
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(actor.phases).isEqualTo(LifecycleRecordingActor.FULL_LIFECYCLE);
    }

    @Test
    public void shouldReturnNonCompletedFutureAfterRecycle() {
        LifecycleRecordingActor actor = new LifecycleRecordingActor();
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        ActorFuture<Void> actorStartedFuture = this.schedulerRule.submitActor(actor);
        Assertions.assertThat(actorStartedFuture).isNotDone();
    }

    @Test
    public void shouldNotAllowMultipleActorSubmit() {
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorCloseRequested() {
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        ThrowableAssert.ThrowingCallable throwsOnExecute = () -> this.schedulerRule.submitActor(actor);
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwsOnExecute).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void shouldAllowMultipleActorSubmitAfterClosed() throws Exception {
        final AtomicLong startedCount = new AtomicLong(0L);
        final CountDownLatch latch = new CountDownLatch(1);
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarted() {
                startedCount.incrementAndGet();
            }

            @Override
            public void onActorClosed() {
                latch.countDown();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        latch.await();
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((AtomicLong)startedCount).hasValue(2L);
    }

    @Test
    public void shouldNotExecutePreviouslySubmittedJobs() throws Exception {
        Runnable action = (Runnable)Mockito.mock(Runnable.class);
        final CompletableActorFuture future = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorCloseRequested() {
                this.blockPhase((ActorFuture<Void>)future);
            }
        };
        this.schedulerRule.submitActor(actor);
        ActorFuture closeFuture = actor.closeAsync();
        this.schedulerRule.workUntilDone();
        actor.control().run(action);
        future.complete(null);
        this.schedulerRule.workUntilDone();
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{action});
    }

    @Test
    @Ignore(value="TODO")
    public void shouldNotRecycleIfNotClosed() {
        LifecycleRecordingActor actor = new LifecycleRecordingActor();
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.submitActor(actor);
    }
}

