/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.lifecycle;

import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.lifecycle.LifecycleRecordingActor;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import java.time.Duration;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class ActorLifecyclePhasesAndTimersTest {
    @Rule
    public final ControlledActorSchedulerRule schedulerRule = new ControlledActorSchedulerRule();

    @Test
    public void shouldNotExecuteTimersInStartingPhase() {
        this.schedulerRule.getClock().setCurrentTime(100L);
        final Runnable action = (Runnable)Mockito.mock(Runnable.class);
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                this.actor.schedule(Duration.ofMillis(10L), action);
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        this.schedulerRule.getClock().addTime(Duration.ofMillis(10L));
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)0))).run();
    }

    @Test
    public void shouldExecuteTimersSubmittedInStartingPhaseWhenInStartedPhase() throws Exception {
        this.schedulerRule.getClock().setCurrentTime(100L);
        final Runnable action = (Runnable)Mockito.mock(Runnable.class);
        final CompletableActorFuture future = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                this.actor.schedule(Duration.ofMillis(10L), action);
                this.blockPhase((ActorFuture<Void>)future);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        this.schedulerRule.getClock().addTime(Duration.ofMillis(10L));
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)0))).run();
        future.complete(null);
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void shouldExecuteTimersInStartedPhase() {
        this.schedulerRule.getClock().setCurrentTime(100L);
        final Runnable action = (Runnable)Mockito.mock(Runnable.class);
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarted() {
                this.actor.schedule(Duration.ofMillis(10L), action);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        this.schedulerRule.getClock().addTime(Duration.ofMillis(10L));
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void shouldNotExecuteTimersInCloseRequestedPhase() {
        this.schedulerRule.getClock().setCurrentTime(100L);
        final Runnable action = (Runnable)Mockito.mock(Runnable.class);
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorCloseRequested() {
                this.blockPhase();
                this.actor.schedule(Duration.ofMillis(10L), action);
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        this.schedulerRule.getClock().addTime(Duration.ofMillis(10L));
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)0))).run();
    }

    @Test
    public void shouldNotExecuteTimersInClosingPhase() {
        this.schedulerRule.getClock().setCurrentTime(100L);
        final Runnable action = (Runnable)Mockito.mock(Runnable.class);
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorClosing() {
                this.blockPhase();
                this.actor.schedule(Duration.ofMillis(10L), action);
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        this.schedulerRule.getClock().addTime(Duration.ofMillis(10L));
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)0))).run();
    }
}

