/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.lifecycle;

import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.lifecycle.LifecycleRecordingActor;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class ActorLifecyclePhasesAndSubmitTest {
    @Rule
    public final ControlledActorSchedulerRule schedulerRule = new ControlledActorSchedulerRule();

    @Test
    public void shouldNotExecuteSubmittedJobsInStartingPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                this.actor.submit(runnable);
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)0))).run();
    }

    @Test
    public void shouldExecuteSubmittedJobsInStartingPhaseWhenInStartedPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        final CompletableActorFuture future = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                this.actor.submit(runnable);
                this.blockPhase((ActorFuture<Void>)future);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)0))).run();
        future.complete(null);
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void shouldExecuteSubmittedJobsInStartedPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarted() {
                this.actor.submit(runnable);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void shouldNotExecuteSubmittedJobsInCloseRequestedPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorCloseRequested() {
                this.actor.submit(runnable);
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)0))).run();
    }

    @Test
    public void shouldNotExecuteSubmittedJobsInClosingPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorClosing() {
                this.actor.submit(runnable);
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)0))).run();
    }

    @Test
    public void shouldNotExecuteSubmittedJobsInClosedPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorClosed() {
                this.actor.submit(runnable);
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)0))).run();
    }
}

