/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.lifecycle;

import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.lifecycle.LifecycleRecordingActor;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class ActorLifecyclePhasesAndRunTest {
    @Rule
    public final ControlledActorSchedulerRule schedulerRule = new ControlledActorSchedulerRule();

    @Test
    public void shouldExecuteInternallySubmittedActionsInStartingPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                this.actor.run(runnable);
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void shouldExecuteInternallySubmittedActionsInStartingPhaseWhenInStartedPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        final CompletableActorFuture future = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                this.actor.run(runnable);
                this.blockPhase((ActorFuture<Void>)future);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)1))).run();
        future.complete(null);
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void shouldExecuteInternallySubmittedActionsInStartedPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarted() {
                this.actor.run(runnable);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void shouldExecuteInternallySubmittedActionsInCloseRequestedPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorCloseRequested() {
                this.actor.run(runnable);
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void shouldExecuteInternallySubmittedActionsInClosingPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorClosing() {
                this.actor.run(runnable);
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void shouldExecuteInternallySubmittedActionsInClosedPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorClosed() {
                this.actor.run(runnable);
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void shouldNotExecuteExternallySubmittedActionsInStartingPhase() throws Exception {
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        actor.control().run(runnable);
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)0))).run();
    }

    @Test
    public void shouldExecuteExternallySubmittedActionsSubmittedInStartingPhaseWhenInStartedPhase() throws Exception {
        final CompletableActorFuture future = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                this.blockPhase((ActorFuture<Void>)future);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        actor.control().run(runnable);
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)0))).run();
        future.complete(null);
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void shouldExecuteExternallySubmittedActionsInStartedPhase() throws Exception {
        LifecycleRecordingActor actor = new LifecycleRecordingActor();
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        actor.control().run(runnable);
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void shouldNotExecuteExternallySubmittedActionsInCloseRequestedPhase() throws Exception {
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorCloseRequested() {
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        actor.control().run(runnable);
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)0))).run();
    }

    @Test
    public void shouldNotExecuteExternallySubmittedActionsInClosingPhase() throws Exception {
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorClosing() {
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        actor.control().run(runnable);
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)0))).run();
    }

    @Test
    public void shouldNotExecuteExternallySubmittedActionsInClosedPhase() throws Exception {
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorClosed() {
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        actor.control().run(runnable);
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)0))).run();
    }
}

