/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.lifecycle;

import io.camunda.zeebe.scheduler.ActorTask;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.lifecycle.LifecycleRecordingActor;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public final class ActorLifecyclePhasesAndRunOnCompletionTest {
    @Rule
    public final ControlledActorSchedulerRule schedulerRule = new ControlledActorSchedulerRule();

    @Test
    public void shouldWaitForFutureInStarting() {
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                super.onActorStarting();
                this.runOnCompletion();
            }
        };
        ActorFuture<Void> startFuture = this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(startFuture).isNotDone();
        Assertions.assertThat(actor.phases).isEqualTo((Object)Lists.newArrayList((Object[])new ActorTask.ActorLifecyclePhase[]{ActorTask.ActorLifecyclePhase.STARTING}));
    }

    @Test
    public void shouldContinueWhenFutureInStartingResolved() {
        final CompletableActorFuture future = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                super.onActorStarting();
                this.runOnCompletion((ActorFuture<Void>)future);
            }
        };
        ActorFuture<Void> startFuture = this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        future.complete(null);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(startFuture).isDone();
        Assertions.assertThat(actor.phases).isEqualTo((Object)Lists.newArrayList((Object[])new ActorTask.ActorLifecyclePhase[]{ActorTask.ActorLifecyclePhase.STARTING, ActorTask.ActorLifecyclePhase.STARTED}));
    }

    @Test
    public void shouldNotWaitOnFutureInCloseRequestedSubmittedInStarted() {
        final BiConsumer callback = (BiConsumer)Mockito.mock(BiConsumer.class);
        final CompletableActorFuture future = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarted() {
                super.onActorStarted();
                this.runOnCompletion((ActorFuture)future, callback);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ActorFuture closeFuture = actor.closeAsync();
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)closeFuture).isDone();
        Assertions.assertThat(actor.phases).isEqualTo((Object)Lists.newArrayList(LifecycleRecordingActor.FULL_LIFECYCLE));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
    }

    @Test
    public void shouldNotWaitOnFutureInCloseRequestedSubmittedInCloseRequested() {
        final BiConsumer callback = (BiConsumer)Mockito.mock(BiConsumer.class);
        final CompletableActorFuture future = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorCloseRequested() {
                super.onActorCloseRequested();
                this.runOnCompletion((ActorFuture)future, callback);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ActorFuture closeFuture = actor.closeAsync();
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)closeFuture).isDone();
        Assertions.assertThat(actor.phases).isEqualTo(LifecycleRecordingActor.FULL_LIFECYCLE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
    }

    @Test
    public void shouldNotWaitOnFutureInClosed() {
        final BiConsumer callback = (BiConsumer)Mockito.mock(BiConsumer.class);
        final CompletableActorFuture future = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorClosed() {
                super.onActorClosed();
                this.runOnCompletion((ActorFuture)future, callback);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ActorFuture closeFuture = actor.closeAsync();
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)closeFuture).isDone();
        Assertions.assertThat(actor.phases).isEqualTo((Object)Lists.newArrayList(LifecycleRecordingActor.FULL_LIFECYCLE));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
    }

    @Test
    public void shouldWaitOnFutureInClosing() {
        final BiConsumer callback = (BiConsumer)Mockito.mock(BiConsumer.class);
        final CompletableActorFuture future = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorClosing() {
                super.onActorClosing();
                this.runOnCompletion((ActorFuture)future, callback);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ActorFuture closeFuture = actor.closeAsync();
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)closeFuture).isNotDone();
        Assertions.assertThat(actor.phases).isEqualTo((Object)Lists.newArrayList((Object[])new ActorTask.ActorLifecyclePhase[]{ActorTask.ActorLifecyclePhase.STARTING, ActorTask.ActorLifecyclePhase.STARTED, ActorTask.ActorLifecyclePhase.CLOSE_REQUESTED, ActorTask.ActorLifecyclePhase.CLOSING}));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
    }

    @Test
    public void shouldContinueWhenFutureInClosingResolved() {
        final CompletableActorFuture future = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorClosing() {
                super.onActorClosing();
                this.runOnCompletion((ActorFuture<Void>)future);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ActorFuture closeFuture = actor.closeAsync();
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)closeFuture).isNotDone();
        future.complete(null);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)closeFuture).isDone();
        Assertions.assertThat(actor.phases).isEqualTo(LifecycleRecordingActor.FULL_LIFECYCLE);
    }

    @Test
    public void shouldNotExecuteFutureSubmittedInStartedAfterCloseRequested() {
        final CompletableActorFuture futureInStarted = new CompletableActorFuture();
        final CompletableActorFuture futureInStartedCompleted = new CompletableActorFuture();
        final CompletableActorFuture futureInClosing = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarted() {
                this.actor.runOnCompletion((ActorFuture)futureInStarted, (r1, t1) -> futureInStartedCompleted.complete(null));
            }

            @Override
            public void onActorClosing() {
                super.onActorClosing();
                this.runOnCompletion((ActorFuture<Void>)futureInClosing);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ActorFuture closeFuture = actor.closeAsync();
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)closeFuture).isNotDone();
        futureInStarted.complete(null);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)futureInStartedCompleted).isNotDone();
        Assertions.assertThat((Future)closeFuture).isNotDone();
        futureInClosing.complete(null);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)closeFuture).isDone();
        Assertions.assertThat((Future)futureInStartedCompleted).isNotDone();
        Assertions.assertThat(actor.phases).isEqualTo((Object)Lists.newArrayList((Object[])new ActorTask.ActorLifecyclePhase[]{ActorTask.ActorLifecyclePhase.STARTING, ActorTask.ActorLifecyclePhase.CLOSE_REQUESTED, ActorTask.ActorLifecyclePhase.CLOSING, ActorTask.ActorLifecyclePhase.CLOSED}));
    }

    @Test
    public void shouldWaitOnFutureSubmittedInCallback() {
        final CompletableActorFuture future1 = new CompletableActorFuture();
        final CompletableActorFuture future2 = new CompletableActorFuture();
        final CompletableActorFuture future3 = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                super.onActorStarting();
                this.actor.runOnCompletion((ActorFuture)future1, (r1, t1) -> this.actor.runOnCompletion((ActorFuture)future2, (r2, t2) -> future3.complete(null)));
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)future3).isNotDone();
        Assertions.assertThat(actor.phases).isEqualTo((Object)Lists.newArrayList((Object[])new ActorTask.ActorLifecyclePhase[]{ActorTask.ActorLifecyclePhase.STARTING}));
        future1.complete(null);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)future3).isNotDone();
        Assertions.assertThat(actor.phases).isEqualTo((Object)Lists.newArrayList((Object[])new ActorTask.ActorLifecyclePhase[]{ActorTask.ActorLifecyclePhase.STARTING}));
        future2.complete(null);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)future3).isDone();
        Assertions.assertThat(actor.phases).isEqualTo((Object)Lists.newArrayList((Object[])new ActorTask.ActorLifecyclePhase[]{ActorTask.ActorLifecyclePhase.STARTING, ActorTask.ActorLifecyclePhase.STARTED}));
    }
}

