/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.lifecycle;

import io.camunda.zeebe.scheduler.ActorCondition;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.lifecycle.LifecycleRecordingActor;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class ActorLifecyclePhasesAndConditionsTest {
    @Rule
    public final ControlledActorSchedulerRule schedulerRule = new ControlledActorSchedulerRule();

    @Test
    public void shouldNotExecuteConditionalJobsInStartingPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        final CompletableActorFuture conditionFuture = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                conditionFuture.complete((Object)this.actor.onCondition("condition", runnable));
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ActorCondition condition = (ActorCondition)conditionFuture.join();
        condition.signal();
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)0))).run();
    }

    @Test
    public void shouldExecuteConditionalJobsInStartingPhaseWhenInStartedPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        final CompletableActorFuture future = new CompletableActorFuture();
        final CompletableActorFuture conditionFuture = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                conditionFuture.complete((Object)this.actor.onCondition("condition", runnable));
                this.blockPhase((ActorFuture<Void>)future);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ((ActorCondition)conditionFuture.join()).signal();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)0))).run();
        future.complete(null);
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void shouldExecuteConditionalJobsInStartedPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        final CompletableActorFuture conditionFuture = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarted() {
                conditionFuture.complete((Object)this.actor.onCondition("condition", runnable));
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ActorCondition condition = (ActorCondition)conditionFuture.join();
        condition.signal();
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void shouldNotExecuteConditionalJobsInCloseRequestedPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        final CompletableActorFuture conditionFuture = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorCloseRequested() {
                conditionFuture.complete((Object)this.actor.onCondition("condition", runnable));
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        ActorCondition condition = (ActorCondition)conditionFuture.join();
        condition.signal();
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)0))).run();
    }

    @Test
    public void shouldNotExecuteConditionalJobsInClosingPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        final CompletableActorFuture conditionFuture = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorClosing() {
                conditionFuture.complete((Object)this.actor.onCondition("condition", runnable));
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        ActorCondition condition = (ActorCondition)conditionFuture.join();
        condition.signal();
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)0))).run();
    }

    @Test
    public void shouldNotExecuteConditionalJobsInClosedPhase() throws Exception {
        final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        final CompletableActorFuture conditionFuture = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorClosed() {
                conditionFuture.complete((Object)this.actor.onCondition("condition", runnable));
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        ActorCondition condition = (ActorCondition)conditionFuture.join();
        condition.signal();
        this.schedulerRule.workUntilDone();
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)0))).run();
    }
}

