/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.lifecycle;

import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.lifecycle.LifecycleRecordingActor;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import java.util.concurrent.Callable;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class ActorLifecyclePhasesAndCallablesTest {
    @Rule
    public final ControlledActorSchedulerRule schedulerRule = new ControlledActorSchedulerRule();

    @Test
    public void shouldNotExecuteCallablesInStartingPhase() throws Exception {
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Callable callable = (Callable)Mockito.mock(Callable.class);
        actor.control().call(callable);
        this.schedulerRule.workUntilDone();
        ((Callable)Mockito.verify((Object)callable, (VerificationMode)Mockito.times((int)0))).call();
    }

    @Test
    public void shouldExecuteCallablesSubmittedInStartingPhaseWhenInStartedPhase() throws Exception {
        final CompletableActorFuture future = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                this.blockPhase((ActorFuture<Void>)future);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Callable callable = (Callable)Mockito.mock(Callable.class);
        actor.control().call(callable);
        this.schedulerRule.workUntilDone();
        ((Callable)Mockito.verify((Object)callable, (VerificationMode)Mockito.times((int)0))).call();
        future.complete(null);
        this.schedulerRule.workUntilDone();
        ((Callable)Mockito.verify((Object)callable, (VerificationMode)Mockito.times((int)1))).call();
    }

    @Test
    public void shouldExecuteCallablesInStartedPhase() throws Exception {
        LifecycleRecordingActor actor = new LifecycleRecordingActor();
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Callable callable = (Callable)Mockito.mock(Callable.class);
        actor.control().call(callable);
        this.schedulerRule.workUntilDone();
        ((Callable)Mockito.verify((Object)callable, (VerificationMode)Mockito.times((int)1))).call();
    }

    @Test
    public void shouldNotExecuteCallablesInCloseRequestedPhase() throws Exception {
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorCloseRequested() {
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        Callable callable = (Callable)Mockito.mock(Callable.class);
        actor.control().call(callable);
        this.schedulerRule.workUntilDone();
        ((Callable)Mockito.verify((Object)callable, (VerificationMode)Mockito.times((int)0))).call();
    }

    @Test
    public void shouldNotExecuteCallablesInClosingPhase() throws Exception {
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorClosing() {
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        Callable callable = (Callable)Mockito.mock(Callable.class);
        actor.control().call(callable);
        this.schedulerRule.workUntilDone();
        ((Callable)Mockito.verify((Object)callable, (VerificationMode)Mockito.times((int)0))).call();
    }

    @Test
    public void shouldNotExecuteCallablesInClosedPhase() throws Exception {
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorClosed() {
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        Callable callable = (Callable)Mockito.mock(Callable.class);
        actor.control().call(callable);
        this.schedulerRule.workUntilDone();
        ((Callable)Mockito.verify((Object)callable, (VerificationMode)Mockito.times((int)0))).call();
    }
}

