/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.lifecycle;

import io.camunda.zeebe.scheduler.ActorTask;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.lifecycle.LifecycleRecordingActor;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public final class ActorLifecyclePhasesAndBlockPhaseTest {
    @Rule
    public final ControlledActorSchedulerRule schedulerRule = new ControlledActorSchedulerRule();

    @Test
    public void shouldWaitForFutureInStarting() {
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                super.onActorStarting();
                this.blockPhase();
            }
        };
        ActorFuture<Void> startFuture = this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(startFuture).isNotDone();
        Assertions.assertThat(actor.phases).isEqualTo((Object)Lists.newArrayList((Object[])new ActorTask.ActorLifecyclePhase[]{ActorTask.ActorLifecyclePhase.STARTING}));
    }

    @Test
    public void shouldContinueWhenFutureInStartingResolved() {
        final CompletableActorFuture future = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                super.onActorStarting();
                this.blockPhase((ActorFuture<Void>)future);
            }
        };
        ActorFuture<Void> startFuture = this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        future.complete(null);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(startFuture).isDone();
        Assertions.assertThat(actor.phases).isEqualTo((Object)Lists.newArrayList((Object[])new ActorTask.ActorLifecyclePhase[]{ActorTask.ActorLifecyclePhase.STARTING, ActorTask.ActorLifecyclePhase.STARTED}));
    }

    @Test
    public void shouldWaitOnFutureInCloseRequested() {
        final BiConsumer callback = (BiConsumer)Mockito.mock(BiConsumer.class);
        final CompletableActorFuture future = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarted() {
                super.onActorStarted();
                this.blockPhase((ActorFuture<Void>)future, callback);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ActorFuture closeFuture = actor.closeAsync();
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)closeFuture).isNotDone();
        Assertions.assertThat(actor.phases).isEqualTo((Object)Lists.newArrayList((Object[])new ActorTask.ActorLifecyclePhase[]{ActorTask.ActorLifecyclePhase.STARTING, ActorTask.ActorLifecyclePhase.STARTED, ActorTask.ActorLifecyclePhase.CLOSE_REQUESTED}));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
    }

    @Test
    public void shouldCompleteCloseRequestedWhenFutureCompleted() {
        final CompletableActorFuture future = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarted() {
                super.onActorStarted();
                this.blockPhase((ActorFuture<Void>)future);
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ActorFuture closeFuture = actor.closeAsync();
        this.schedulerRule.workUntilDone();
        future.complete(null);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)closeFuture).isDone();
        Assertions.assertThat(actor.phases).isEqualTo(LifecycleRecordingActor.FULL_LIFECYCLE);
    }

    @Test
    public void shouldNotWaitOnFutureInClosed() {
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorClosed() {
                super.onActorClosed();
                this.blockPhase();
            }
        };
        this.schedulerRule.submitActor(actor);
        ActorFuture closeFuture = actor.closeAsync();
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)closeFuture).isDone();
        Assertions.assertThat(actor.phases).isEqualTo(LifecycleRecordingActor.FULL_LIFECYCLE);
    }

    @Test
    public void shouldNotWaitForNestedRunOnCompletion() {
        final CompletableActorFuture trigger = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarted() {
                super.onActorClosed();
                this.actor.runOnCompletionBlockingCurrentPhase((ActorFuture)trigger, (r1, e1) -> this.actor.runOnCompletion((ActorFuture)new CompletableActorFuture(), (r2, e2) -> {}));
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        ActorFuture closeFuture = actor.closeAsync();
        trigger.complete(null);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)closeFuture).isDone();
    }

    @Test
    public void shouldWaitOnFutureSubmittedInCallback() {
        final CompletableActorFuture future1 = new CompletableActorFuture();
        final CompletableActorFuture future2 = new CompletableActorFuture();
        final CompletableActorFuture future3 = new CompletableActorFuture();
        LifecycleRecordingActor actor = new LifecycleRecordingActor(this){

            @Override
            public void onActorStarting() {
                super.onActorStarting();
                this.actor.runOnCompletionBlockingCurrentPhase((ActorFuture)future1, (r1, t1) -> this.actor.runOnCompletionBlockingCurrentPhase((ActorFuture)future2, (r2, t2) -> future3.complete(null)));
            }
        };
        this.schedulerRule.submitActor(actor);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)future3).isNotDone();
        Assertions.assertThat(actor.phases).isEqualTo((Object)Lists.newArrayList((Object[])new ActorTask.ActorLifecyclePhase[]{ActorTask.ActorLifecyclePhase.STARTING}));
        future1.complete(null);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)future3).isNotDone();
        Assertions.assertThat(actor.phases).isEqualTo((Object)Lists.newArrayList((Object[])new ActorTask.ActorLifecyclePhase[]{ActorTask.ActorLifecyclePhase.STARTING}));
        future2.complete(null);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((Future)future3).isDone();
        Assertions.assertThat(actor.phases).isEqualTo((Object)Lists.newArrayList((Object[])new ActorTask.ActorLifecyclePhase[]{ActorTask.ActorLifecyclePhase.STARTING, ActorTask.ActorLifecyclePhase.STARTED}));
    }
}

