/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.iobound;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorThread;
import io.camunda.zeebe.scheduler.ActorThreadGroup;
import io.camunda.zeebe.scheduler.CpuThreadGroup;
import io.camunda.zeebe.scheduler.SchedulingHints;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.ActorSchedulerRule;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;

public final class IoBoundActorsIntegrationTest {
    @Rule
    public final ActorSchedulerRule schedulerRule = new ActorSchedulerRule();

    @Test
    public void shouldRunIoBoundActor() {
        ActorThreadGroup ioBoundActorThreads = this.schedulerRule.getBuilder().getIoBoundActorThreads();
        final AtomicReference threadGroupRef = new AtomicReference();
        Actor actor = new Actor(this){

            protected void onActorStarting() {
                threadGroupRef.set(ActorThread.current().getActorThreadGroup());
            }
        };
        this.schedulerRule.get().submitActor(actor, SchedulingHints.ioBound()).join();
        Assertions.assertThat((Object)((ActorThreadGroup)threadGroupRef.get())).isEqualTo((Object)ioBoundActorThreads);
    }

    @Test
    public void shouldStayOnIoBoundThreadGroupWhenInteractingWithCpuBound() {
        final ActorThreadGroup ioBoundActorThreads = this.schedulerRule.getBuilder().getIoBoundActorThreads();
        final AtomicBoolean isOnWrongThreadGroup = new AtomicBoolean();
        final CallableActor callableActor = new CallableActor(this, isOnWrongThreadGroup);
        Actor ioBoundActor = new Actor(this){

            protected void onActorStarting() {
                for (int i = 0; i < 1000; ++i) {
                    this.actor.runOnCompletion(callableActor.doCall(), this::callback);
                }
            }

            protected void callback(Void res, Throwable t) {
                if (ActorThread.current().getActorThreadGroup() != ioBoundActorThreads) {
                    isOnWrongThreadGroup.set(true);
                }
            }
        };
        this.schedulerRule.submitActor(callableActor).join();
        this.schedulerRule.get().submitActor(ioBoundActor, SchedulingHints.ioBound()).join();
        Assertions.assertThat((AtomicBoolean)isOnWrongThreadGroup).isFalse();
    }

    @Test
    public void shouldStayOnIoBoundThreadGroupWhenInteractingWithCpuBoundOnBlockingPhase() {
        final ActorThreadGroup ioBoundActorThreads = this.schedulerRule.getBuilder().getIoBoundActorThreads();
        final AtomicBoolean isOnWrongThreadGroup = new AtomicBoolean();
        final CallableActor callableActor = new CallableActor(this, isOnWrongThreadGroup);
        Actor ioBoundActor = new Actor(this){

            protected void onActorStarting() {
                for (int i = 0; i < 1000; ++i) {
                    this.actor.runOnCompletionBlockingCurrentPhase(callableActor.doCall(), this::callback);
                }
            }

            protected void callback(Void res, Throwable t) {
                if (ActorThread.current().getActorThreadGroup() != ioBoundActorThreads) {
                    isOnWrongThreadGroup.set(true);
                }
            }
        };
        this.schedulerRule.submitActor(callableActor).join();
        this.schedulerRule.get().submitActor(ioBoundActor, SchedulingHints.ioBound()).join();
        Assertions.assertThat((AtomicBoolean)isOnWrongThreadGroup).isFalse();
    }

    class CallableActor
    extends Actor {
        private final AtomicBoolean isOnWrongThreadGroup;

        CallableActor(IoBoundActorsIntegrationTest this$0, AtomicBoolean isOnWrongThreadGroup) {
            this.isOnWrongThreadGroup = isOnWrongThreadGroup;
        }

        public ActorFuture<Void> doCall() {
            return this.actor.call(() -> {
                if (!(ActorThread.current().getActorThreadGroup() instanceof CpuThreadGroup)) {
                    this.isOnWrongThreadGroup.set(true);
                }
            });
        }
    }
}

