/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.health;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.health.CriticalComponentsHealthMonitor;
import io.camunda.zeebe.scheduler.testing.ActorSchedulerRule;
import io.camunda.zeebe.util.health.FailureListener;
import io.camunda.zeebe.util.health.HealthIssue;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthReport;
import io.camunda.zeebe.util.health.HealthStatus;
import java.util.HashSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class CriticalComponentsHealthMonitorTest {
    @Rule
    public ActorSchedulerRule actorSchedulerRule = new ActorSchedulerRule();
    private CriticalComponentsHealthMonitor monitor;
    private ActorControl actorControl;

    @Before
    public void setup() {
        Actor testActor = new Actor(){

            public String getName() {
                return "test-actor";
            }

            protected void onActorStarting() {
                CriticalComponentsHealthMonitorTest.this.monitor = new CriticalComponentsHealthMonitor("TestMonitor", this.actor, LoggerFactory.getLogger((String)"test"));
                CriticalComponentsHealthMonitorTest.this.actorControl = this.actor;
            }

            protected void onActorStarted() {
                CriticalComponentsHealthMonitorTest.this.monitor.startMonitoring();
            }
        };
        this.actorSchedulerRule.submitActor(testActor).join();
    }

    @Test
    public void shouldMonitorComponent() {
        ControllableComponent component = new ControllableComponent();
        this.monitor.registerComponent("test", (HealthMonitorable)component);
        this.waitUntilAllDone();
        Assertions.assertThat((Comparable)this.monitor.getHealthReport().getStatus()).isEqualTo((Object)HealthStatus.HEALTHY);
        component.setUnhealthy();
        this.waitUntilAllDone();
        Assertions.assertThat((Comparable)this.monitor.getHealthReport().getStatus()).isEqualTo((Object)HealthStatus.UNHEALTHY);
    }

    @Test
    public void shouldRecover() {
        ControllableComponent component = new ControllableComponent();
        this.monitor.registerComponent("test", (HealthMonitorable)component);
        this.waitUntilAllDone();
        component.setUnhealthy();
        this.waitUntilAllDone();
        Assertions.assertThat((Comparable)this.monitor.getHealthReport().getStatus()).isEqualTo((Object)HealthStatus.UNHEALTHY);
        component.setHealthy();
        this.waitUntilAllDone();
        Assertions.assertThat((Comparable)this.monitor.getHealthReport().getStatus()).isEqualTo((Object)HealthStatus.HEALTHY);
    }

    @Test
    public void shouldMonitorMultipleComponent() {
        ControllableComponent component1 = new ControllableComponent();
        ControllableComponent component2 = new ControllableComponent();
        this.monitor.registerComponent("test1", (HealthMonitorable)component1);
        this.monitor.registerComponent("test2", (HealthMonitorable)component2);
        this.waitUntilAllDone();
        Assertions.assertThat((Comparable)this.monitor.getHealthReport().getStatus()).isEqualTo((Object)HealthStatus.HEALTHY);
        component2.setUnhealthy();
        this.waitUntilAllDone();
        Assertions.assertThat((Comparable)this.monitor.getHealthReport().getStatus()).isEqualTo((Object)HealthStatus.UNHEALTHY);
        component2.setHealthy();
        component1.setUnhealthy();
        this.waitUntilAllDone();
        Assertions.assertThat((Comparable)this.monitor.getHealthReport().getStatus()).isEqualTo((Object)HealthStatus.UNHEALTHY);
        component1.setHealthy();
        this.waitUntilAllDone();
        Assertions.assertThat((Comparable)this.monitor.getHealthReport().getStatus()).isEqualTo((Object)HealthStatus.HEALTHY);
    }

    @Test
    public void shouldRemoveComponent() {
        ControllableComponent component = new ControllableComponent();
        this.monitor.registerComponent("test", (HealthMonitorable)component);
        Awaitility.await().until(() -> this.monitor.getHealthReport().getStatus() == HealthStatus.HEALTHY);
        this.monitor.removeComponent("test");
        this.waitUntilAllDone();
        component.setUnhealthy();
        this.waitUntilAllDone();
        Assertions.assertThat((Comparable)this.monitor.getHealthReport().getStatus()).isEqualTo((Object)HealthStatus.HEALTHY);
    }

    @Test
    public void shouldMonitorComponentDeath() {
        ControllableComponent component1 = new ControllableComponent();
        ControllableComponent component2 = new ControllableComponent();
        this.monitor.registerComponent("comp1", (HealthMonitorable)component1);
        this.monitor.registerComponent("comp2", (HealthMonitorable)component2);
        this.waitUntilAllDone();
        component1.setUnhealthy();
        component2.setDead();
        this.waitUntilAllDone();
        Assertions.assertThat((Comparable)this.monitor.getHealthReport().getStatus()).isEqualTo((Object)HealthStatus.DEAD);
        component1.setHealthy();
        this.waitUntilAllDone();
        Assertions.assertThat((Comparable)this.monitor.getHealthReport().getStatus()).isEqualTo((Object)HealthStatus.DEAD);
    }

    @Test
    public void shouldTrackRootIssue() {
        HealthIssue issue = HealthIssue.of((Throwable)new IllegalStateException());
        ControllableComponent component = new ControllableComponent();
        this.monitor.registerComponent("component", (HealthMonitorable)component);
        this.waitUntilAllDone();
        component.setDead(issue);
        this.waitUntilAllDone();
        Assertions.assertThat((Object)this.monitor.getHealthReport().getIssue().cause().getIssue()).isEqualTo((Object)issue);
    }

    private void waitUntilAllDone() {
        this.actorControl.call(() -> null).join();
    }

    private static final class ControllableComponent
    implements HealthMonitorable {
        private final Set<FailureListener> failureListeners = new HashSet<FailureListener>();
        private volatile HealthReport healthReport = HealthReport.healthy((HealthMonitorable)this);

        private ControllableComponent() {
        }

        public HealthReport getHealthReport() {
            return this.healthReport;
        }

        public void addFailureListener(FailureListener failureListener) {
            this.failureListeners.add(failureListener);
        }

        public void removeFailureListener(FailureListener failureListener) {
            this.failureListeners.remove(failureListener);
        }

        void setHealthy() {
            if (this.healthReport.getStatus() != HealthStatus.HEALTHY) {
                this.failureListeners.forEach(FailureListener::onRecovered);
                this.healthReport = HealthReport.healthy((HealthMonitorable)this);
            }
        }

        void setUnhealthy() {
            if (this.healthReport.getStatus() != HealthStatus.UNHEALTHY) {
                this.healthReport = HealthReport.unhealthy((HealthMonitorable)this).withMessage("manually set to status unhealthy");
                this.failureListeners.forEach(l -> l.onFailure(this.healthReport));
            }
        }

        void setDead() {
            this.setDead(HealthIssue.of((String)"manually set to status dead"));
        }

        void setDead(HealthIssue issue) {
            if (this.healthReport.getStatus() != HealthStatus.DEAD) {
                this.healthReport = HealthReport.dead((HealthMonitorable)this).withIssue(issue);
                this.failureListeners.forEach(l -> l.onUnrecoverableFailure(this.healthReport));
            }
        }
    }
}

