/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.future;

import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.ActorFutureCollector;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ActorFutureCollectorTest {
    private ActorFuture<String> future1;
    private ActorFuture<String> future2;
    private ActorFuture<List<String>> aggregatedFuture;

    @BeforeEach
    public void setUp() {
        TestConcurrencyControl concurrencyControl = new TestConcurrencyControl();
        this.future1 = concurrencyControl.createFuture();
        this.future2 = concurrencyControl.createFuture();
        this.aggregatedFuture = (ActorFuture)Stream.of(this.future1, this.future2).collect(new ActorFutureCollector((ConcurrencyControl)concurrencyControl));
    }

    @Test
    public void shouldAggregateResults() {
        this.future1.complete((Object)"result1");
        this.future2.complete((Object)"result2");
        Assertions.assertThat((List)((List)this.aggregatedFuture.join())).containsExactly((Object[])new String[]{"result1", "result2"});
    }

    @Test
    public void shouldCompleteWithException() {
        Exception testException = new Exception("future2 threw exception");
        this.future1.complete((Object)"result1");
        this.future2.completeExceptionally((Throwable)testException);
        Assertions.assertThatThrownBy(() -> this.aggregatedFuture.join()).getCause().hasSuppressedException((Throwable)testException);
    }

    @Test
    public void shouldAggregateExceptions() {
        Exception testException1 = new Exception("future1 threw exception");
        Exception testException2 = new Exception("future2 threw exception");
        this.future1.completeExceptionally((Throwable)testException1);
        this.future2.completeExceptionally((Throwable)testException2);
        Assertions.assertThatThrownBy(() -> this.aggregatedFuture.join()).getCause().hasSuppressedException((Throwable)testException1).hasSuppressedException((Throwable)testException2);
    }
}

