/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.functional;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.ScheduledTimer;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerExtension;
import java.time.Duration;
import java.util.function.Function;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class TimedActionsTest {
    @RegisterExtension
    public final ControlledActorSchedulerExtension actorScheduler = new ControlledActorSchedulerExtension();

    @Nested
    class StampedTimerTests {
        StampedTimerTests() {
        }

        @Test
        public void shouldNotRunActionIfDeadlineNotReached() throws InterruptedException {
            final Runnable action = (Runnable)Mockito.mock(Runnable.class);
            Actor actor = new Actor(this){

                protected void onActorStarted() {
                    this.actor.runAt(1000L, action);
                }
            };
            TimedActionsTest.this.actorScheduler.setClockTime(100L);
            TimedActionsTest.this.actorScheduler.submitActor(actor);
            TimedActionsTest.this.actorScheduler.workUntilDone();
            ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.never())).run();
        }

        @Test
        public void shouldRunActionWhenDeadlineReached() throws InterruptedException {
            final Runnable action = (Runnable)Mockito.mock(Runnable.class);
            Actor actor = new Actor(this){

                protected void onActorStarted() {
                    this.actor.runAt(1000L, action);
                }
            };
            TimedActionsTest.this.actorScheduler.setClockTime(100L);
            TimedActionsTest.this.actorScheduler.submitActor(actor);
            TimedActionsTest.this.actorScheduler.workUntilDone();
            TimedActionsTest.this.actorScheduler.updateClock(Duration.ofMillis(900L));
            TimedActionsTest.this.actorScheduler.workUntilDone();
            ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)1))).run();
        }

        @Test
        public void shouldCancelRunAt() {
            Runnable action = (Runnable)Mockito.mock(Runnable.class);
            TimerActor actor = new TimerActor(actorControl -> actorControl.runAt(1000L, action));
            TimedActionsTest.this.actorScheduler.setClockTime(100L);
            TimedActionsTest.this.actorScheduler.submitActor(actor);
            TimedActionsTest.this.actorScheduler.workUntilDone();
            actor.cancelTimer();
            TimedActionsTest.this.actorScheduler.workUntilDone();
            TimedActionsTest.this.actorScheduler.updateClock(Duration.ofMillis(900L));
            TimedActionsTest.this.actorScheduler.workUntilDone();
            ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)0))).run();
        }

        @Test
        public void shouldCancelRunDelayedAfterExecution() {
            Runnable action = (Runnable)Mockito.mock(Runnable.class);
            TimerActor actor = new TimerActor(actorControl -> actorControl.runAt(1000L, action));
            TimedActionsTest.this.actorScheduler.setClockTime(100L);
            TimedActionsTest.this.actorScheduler.submitActor(actor);
            TimedActionsTest.this.actorScheduler.workUntilDone();
            TimedActionsTest.this.actorScheduler.updateClock(Duration.ofMillis(900L));
            TimedActionsTest.this.actorScheduler.workUntilDone();
            actor.cancelTimer();
            TimedActionsTest.this.actorScheduler.workUntilDone();
        }
    }

    @Nested
    class DelayedTimerTests {
        DelayedTimerTests() {
        }

        @Test
        public void shouldNotRunActionIfDeadlineNotReached() throws InterruptedException {
            final Runnable action = (Runnable)Mockito.mock(Runnable.class);
            Actor actor = new Actor(this){

                protected void onActorStarted() {
                    this.actor.schedule(Duration.ofMillis(10L), action);
                }
            };
            TimedActionsTest.this.actorScheduler.setClockTime(100L);
            TimedActionsTest.this.actorScheduler.submitActor(actor);
            TimedActionsTest.this.actorScheduler.workUntilDone();
            ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.never())).run();
        }

        @Test
        public void shouldRunActionWhenDeadlineReached() throws InterruptedException {
            final Runnable action = (Runnable)Mockito.mock(Runnable.class);
            Actor actor = new Actor(this){

                protected void onActorStarted() {
                    this.actor.schedule(Duration.ofMillis(10L), action);
                }
            };
            TimedActionsTest.this.actorScheduler.setClockTime(100L);
            TimedActionsTest.this.actorScheduler.submitActor(actor);
            TimedActionsTest.this.actorScheduler.workUntilDone();
            TimedActionsTest.this.actorScheduler.updateClock(Duration.ofMillis(10L));
            TimedActionsTest.this.actorScheduler.workUntilDone();
            ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)1))).run();
        }

        @Test
        public void shouldRunAtFixedRate() throws InterruptedException {
            final Runnable action = (Runnable)Mockito.mock(Runnable.class);
            Actor actor = new Actor(this){

                protected void onActorStarted() {
                    this.actor.runAtFixedRate(Duration.ofMillis(10L), action);
                }
            };
            TimedActionsTest.this.actorScheduler.setClockTime(100L);
            TimedActionsTest.this.actorScheduler.submitActor(actor);
            TimedActionsTest.this.actorScheduler.workUntilDone();
            TimedActionsTest.this.actorScheduler.updateClock(Duration.ofMillis(10L));
            TimedActionsTest.this.actorScheduler.workUntilDone();
            ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)1))).run();
            TimedActionsTest.this.actorScheduler.updateClock(Duration.ofMillis(10L));
            TimedActionsTest.this.actorScheduler.workUntilDone();
            ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)2))).run();
            TimedActionsTest.this.actorScheduler.updateClock(Duration.ofMillis(10L));
            TimedActionsTest.this.actorScheduler.workUntilDone();
            ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)3))).run();
        }

        @Test
        public void shouldCancelRunDelayed() {
            Runnable action = (Runnable)Mockito.mock(Runnable.class);
            TimerActor actor = new TimerActor(actorControl -> actorControl.schedule(Duration.ofMillis(10L), action));
            TimedActionsTest.this.actorScheduler.setClockTime(100L);
            TimedActionsTest.this.actorScheduler.submitActor(actor);
            TimedActionsTest.this.actorScheduler.workUntilDone();
            actor.cancelTimer();
            TimedActionsTest.this.actorScheduler.workUntilDone();
            TimedActionsTest.this.actorScheduler.updateClock(Duration.ofMillis(10L));
            TimedActionsTest.this.actorScheduler.workUntilDone();
            ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)0))).run();
        }

        @Test
        public void shouldCancelRunDelayedAfterExecution() {
            Runnable action = (Runnable)Mockito.mock(Runnable.class);
            TimerActor actor = new TimerActor(actorControl -> actorControl.schedule(Duration.ofMillis(10L), action));
            TimedActionsTest.this.actorScheduler.setClockTime(100L);
            TimedActionsTest.this.actorScheduler.submitActor(actor);
            TimedActionsTest.this.actorScheduler.workUntilDone();
            TimedActionsTest.this.actorScheduler.updateClock(Duration.ofMillis(10L));
            TimedActionsTest.this.actorScheduler.workUntilDone();
            actor.cancelTimer();
            TimedActionsTest.this.actorScheduler.workUntilDone();
        }

        @Test
        public void shouldCancelRunAtFixedRate() {
            Runnable action = (Runnable)Mockito.mock(Runnable.class);
            TimerActor actor = new TimerActor(actorControl -> actorControl.runAtFixedRate(Duration.ofMillis(10L), action));
            TimedActionsTest.this.actorScheduler.setClockTime(100L);
            TimedActionsTest.this.actorScheduler.submitActor(actor);
            TimedActionsTest.this.actorScheduler.workUntilDone();
            actor.cancelTimer();
            TimedActionsTest.this.actorScheduler.workUntilDone();
            TimedActionsTest.this.actorScheduler.updateClock(Duration.ofMillis(10L));
            TimedActionsTest.this.actorScheduler.workUntilDone();
            ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)0))).run();
        }
    }

    private static final class TimerActor
    extends Actor {
        private final Function<ActorControl, ScheduledTimer> action;
        private ScheduledTimer scheduledTimer;

        private TimerActor(Function<ActorControl, ScheduledTimer> action) {
            this.action = action;
        }

        protected void onActorStarted() {
            this.scheduledTimer = this.action.apply(this.actor);
        }

        public ActorFuture<Void> cancelTimer() {
            return this.actor.call(() -> this.scheduledTimer.cancel());
        }
    }
}

