/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.functional;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorThread;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;

public final class RunnableActionsTest {
    @Rule
    public final ControlledActorSchedulerRule scheduler = new ControlledActorSchedulerRule();

    @Test
    public void shouldInvokeRunFromWithinActor() {
        Runner runner = new Runner(this){

            protected void onActorStarted() {
                this.doRun();
            }
        };
        this.scheduler.submitActor(runner);
        this.scheduler.workUntilDone();
        Assertions.assertThat((int)runner.runs).isEqualTo(1);
    }

    @Test
    public void shouldInvokeRunFromNonActorThread() {
        Runner runner = new Runner();
        this.scheduler.submitActor(runner);
        runner.doRun();
        this.scheduler.workUntilDone();
        Assertions.assertThat((int)runner.runs).isEqualTo(1);
    }

    @Test
    public void shouldInvokeSubmitFromNonActorThread() {
        AtomicBoolean toggle = new AtomicBoolean(false);
        Submitter submitter = new Submitter();
        this.scheduler.submitActor(submitter);
        submitter.submit(() -> toggle.set(true));
        this.scheduler.workUntilDone();
        Assertions.assertThat((AtomicBoolean)toggle).isTrue();
    }

    @Test
    public void shouldInvokeRunFromAnotherActor() {
        final Runner runner = new Runner();
        Actor invoker = new Actor(this){

            protected void onActorStarted() {
                runner.doRun();
            }
        };
        this.scheduler.submitActor(runner);
        this.scheduler.submitActor(invoker);
        this.scheduler.workUntilDone();
        Assertions.assertThat((int)runner.runs).isEqualTo(1);
    }

    @Test
    public void shouldSubmitRunnableToCorrectActorTask() {
        ArrayList actorContext = new ArrayList();
        final Runner runner = new Runner(() -> actorContext.add(ActorThread.current().getCurrentTask().getActor()));
        Actor invoker = new Actor(this){

            protected void onActorStarted() {
                runner.doRun();
            }
        };
        this.scheduler.submitActor(runner);
        this.scheduler.submitActor(invoker);
        this.scheduler.workUntilDone();
        Assertions.assertThat(actorContext).containsExactly((Object[])new Actor[]{runner});
    }

    @Test
    public void shouldSubmitFromAnotherActor() {
        final AtomicInteger invocations = new AtomicInteger();
        final AtomicBoolean exceptionOnSubmit = new AtomicBoolean(false);
        final Submitter submitter = new Submitter();
        Actor actor = new Actor(this){

            protected void onActorStarted() {
                try {
                    submitter.submit(invocations::incrementAndGet);
                }
                catch (Exception e) {
                    exceptionOnSubmit.set(true);
                }
            }
        };
        this.scheduler.submitActor(submitter);
        this.scheduler.submitActor(actor);
        this.scheduler.workUntilDone();
        Assertions.assertThat((AtomicInteger)invocations).hasValue(1);
        Assertions.assertThat((AtomicBoolean)exceptionOnSubmit).isFalse();
    }

    private static class Runner
    extends Actor {
        int runs = 0;
        final Runnable onExecution;

        Runner() {
            this(null);
        }

        Runner(Runnable onExecution) {
            this.onExecution = onExecution;
        }

        public void doRun() {
            this.actor.run(() -> {
                if (this.onExecution != null) {
                    this.onExecution.run();
                }
                ++this.runs;
            });
        }
    }

    private static final class Submitter
    extends Actor {
        private Submitter() {
        }

        public void submit(Runnable r) {
            this.actor.submit(r);
        }
    }
}

