/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.functional;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorCondition;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class ConditionalActionsTest {
    @Rule
    public final ControlledActorSchedulerRule scheduler = new ControlledActorSchedulerRule();

    @Test
    public void shouldNotTriggerActionIfConditionNotTriggered() {
        final Runnable action = (Runnable)Mockito.mock(Runnable.class);
        final AtomicReference<Object> condition = new AtomicReference<Object>(null);
        Actor actor = new Actor(this){

            protected void onActorStarted() {
                condition.set(this.actor.onCondition("test", action));
            }
        };
        this.scheduler.submitActor(actor);
        this.scheduler.workUntilDone();
        ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void shouldTriggerActionIfConditionTriggered() {
        final Runnable action = (Runnable)Mockito.mock(Runnable.class);
        final AtomicReference<Object> condition = new AtomicReference<Object>(null);
        Actor actor = new Actor(this){

            protected void onActorStarted() {
                condition.set(this.actor.onCondition("test", action));
            }
        };
        this.scheduler.submitActor(actor);
        this.scheduler.workUntilDone();
        ((ActorCondition)condition.get()).signal();
        this.scheduler.workUntilDone();
        ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void shouldTriggerActionOnMultipleSubsequentTriggers() {
        final Runnable action = (Runnable)Mockito.mock(Runnable.class);
        final AtomicReference<Object> condition = new AtomicReference<Object>(null);
        Actor actor = new Actor(this){

            protected void onActorStarted() {
                condition.set(this.actor.onCondition("test", action));
            }
        };
        this.scheduler.submitActor(actor);
        this.scheduler.workUntilDone();
        ActorCondition actorCondition = condition.get();
        actorCondition.signal();
        this.scheduler.workUntilDone();
        ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)1))).run();
        actorCondition.signal();
        this.scheduler.workUntilDone();
        ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)2))).run();
        actorCondition.signal();
        this.scheduler.workUntilDone();
        ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)3))).run();
        actorCondition.signal();
        this.scheduler.workUntilDone();
        ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)4))).run();
    }

    @Test
    public void shouldTriggerActionOnMultipleSubsequentTriggersConcurrently() {
        final Runnable action = (Runnable)Mockito.mock(Runnable.class);
        final AtomicReference<Object> condition = new AtomicReference<Object>(null);
        Actor actor = new Actor(this){

            protected void onActorStarted() {
                condition.set(this.actor.onCondition("test", action));
            }
        };
        this.scheduler.submitActor(actor);
        this.scheduler.workUntilDone();
        ActorCondition actorCondition = condition.get();
        actorCondition.signal();
        actorCondition.signal();
        actorCondition.signal();
        actorCondition.signal();
        this.scheduler.workUntilDone();
        ((Runnable)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)4))).run();
    }

    @Test
    public void shouldTerminateOnFollowUpAndYield() {
        final AtomicInteger invocations = new AtomicInteger(0);
        final AtomicReference condition = new AtomicReference();
        Actor actor = new Actor(this){

            protected void onActorStarted() {
                condition.set(this.actor.onCondition("foo", this::onCondition));
            }

            protected void onCondition() {
                invocations.incrementAndGet();
                this.actor.run(this::doNothing);
                this.actor.yieldThread();
            }

            protected void doNothing() {
            }
        };
        this.scheduler.submitActor(actor);
        this.scheduler.workUntilDone();
        ((ActorCondition)condition.get()).signal();
        this.scheduler.workUntilDone();
        Assertions.assertThat((int)invocations.get()).isEqualTo(1);
    }
}

