/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.functional;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.ActorSchedulerRule;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Rule;
import org.junit.Test;

public final class CallableExecutionTest {
    @Rule
    public final ActorSchedulerRule schedulerRule = new ActorSchedulerRule(3);

    @Test
    public void shouldCompleteFutureExceptionallyWhenSubmittedDuringActorClosedJob() throws InterruptedException, BrokenBarrierException {
        final CyclicBarrier barrier = new CyclicBarrier(2);
        CloseableActor actor = new CloseableActor(this){

            protected void onActorClosed() {
                try {
                    barrier.await();
                    barrier.await();
                }
                catch (InterruptedException | BrokenBarrierException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        barrier.await();
        ActorFuture<Void> future = actor.doCall();
        barrier.await();
        Awaitility.await().until(() -> future.isDone());
        Assertions.assertThat(future).isDone();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> future.get()).isInstanceOf(ExecutionException.class)).hasMessage("Actor is closed");
    }

    class CloseableActor
    extends Actor {
        CloseableActor(CallableExecutionTest this$0) {
        }

        ActorFuture<Void> doCall() {
            return this.actor.call(() -> {});
        }
    }
}

