/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.functional;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;

public final class CallableActionsTest {
    @Rule
    public final ControlledActorSchedulerRule schedulerRule = new ControlledActorSchedulerRule();

    @Test
    public void shouldCompleteFutureOnException() throws Exception {
        Exception expected = new Exception();
        ExceptionActor actor = new ExceptionActor();
        this.schedulerRule.submitActor(actor);
        Future<Void> future = actor.failWith(expected);
        this.schedulerRule.workUntilDone();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> future.get(1L, TimeUnit.MILLISECONDS)).isInstanceOf(ExecutionException.class)).hasCause((Throwable)expected);
        Assertions.assertThat((AtomicInteger)actor.invocations).hasValue(1);
    }

    @Test
    public void shouldCompleteFutureExceptionallyWhenCalledAfterActorClosed() {
        CloseableActor actor = new CloseableActor(this);
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        this.schedulerRule.workUntilDone();
        ActorFuture<Void> future = actor.doCall();
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(future).isDone();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> future.get()).isInstanceOf(ExecutionException.class)).hasMessage("Actor is closed");
    }

    @Test
    public void shouldCompleteFutureExceptionallyWhenActorClosesAfterSubmission() {
        CloseableActor actor = new CloseableActor(this);
        this.schedulerRule.submitActor(actor);
        actor.closeAsync();
        ActorFuture<Void> future = actor.doCall();
        this.schedulerRule.workUntilDone();
        Assertions.assertThat(future).isDone();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> future.get()).isInstanceOf(ExecutionException.class)).hasMessage("Actor is closed");
    }

    protected static class ExceptionActor
    extends Actor {
        protected final AtomicInteger invocations = new AtomicInteger(0);

        protected ExceptionActor() {
        }

        public Future<Void> failWith(Exception e) {
            return this.actor.call(() -> {
                this.invocations.incrementAndGet();
                throw e;
            });
        }
    }

    class CloseableActor
    extends Actor {
        CloseableActor(CallableActionsTest this$0) {
        }

        ActorFuture<Void> doCall() {
            return this.actor.call(() -> {});
        }
    }
}

