/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.SchedulingHints;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

final class ActorSchedulerTest {
    ActorSchedulerTest() {
    }

    @Test
    void shouldCloseUnscheduledTask() {
        TestActor testActor = new TestActor();
        Assertions.assertThat((Future)testActor.closeAsync()).isDone();
    }

    @Test
    void shouldWaitForCloseAfterSchedulingTask() {
        final CountDownLatch latch = new CountDownLatch(1);
        Actor testActor = new Actor(this){

            protected void onActorClosing() {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ActorScheduler scheduler = ActorScheduler.newActorScheduler().build();
        scheduler.start();
        scheduler.submitActor(testActor);
        ActorFuture closeFuture = testActor.closeAsync();
        Assertions.assertThat((Future)closeFuture).isNotDone();
        latch.countDown();
        Assertions.assertThat((Future)closeFuture).succeedsWithin(Duration.ofSeconds(1L));
    }

    @Test
    void shouldThrowIllegalStateExceptionWhenTaskIsSubmittedBeforeActorSchedulerIsNotRunning() {
        TestActor testActor = new TestActor();
        ActorScheduler sut = ActorScheduler.newActorScheduler().build();
        Assertions.assertThatThrownBy(() -> sut.submitActor((Actor)testActor)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> sut.submitActor((Actor)testActor, SchedulingHints.cpuBound())).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void shouldThrowIllegalStateExceptionWhenTaskIsSubmittedAfterActorSchedulerIsStopped() {
        TestActor testActor = new TestActor();
        ActorScheduler sut = ActorScheduler.newActorScheduler().build();
        sut.start();
        Future stopFuture = sut.stop();
        Awaitility.await().until(stopFuture::isDone);
        Assertions.assertThatThrownBy(() -> sut.submitActor((Actor)testActor)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> sut.submitActor((Actor)testActor, SchedulingHints.cpuBound())).isInstanceOf(IllegalStateException.class);
    }

    private static final class TestActor
    extends Actor {
        private TestActor() {
        }
    }
}

