/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import org.agrona.LangUtil;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Rule;
import org.junit.Test;

public final class ActorErrorHandlingTest {
    @Rule
    public final ControlledActorSchedulerRule scheduler = new ControlledActorSchedulerRule();

    @Test
    public void shouldCatchThrowable() {
        Throwable throwable = new Throwable();
        ThrowingActor actor = new ThrowingActor(throwable);
        this.scheduler.submitActor(actor);
        actor.throwError();
        this.scheduler.workUntilDone();
        AssertionsForClassTypes.assertThat((Throwable)actor.recordedFailure).isEqualTo((Object)throwable);
    }

    @Test
    public void shouldCatchException() {
        Exception exception = new Exception();
        ThrowingActor actor = new ThrowingActor(exception);
        this.scheduler.submitActor(actor);
        actor.throwError();
        this.scheduler.workUntilDone();
        AssertionsForClassTypes.assertThat((Throwable)actor.recordedFailure).isEqualTo((Object)exception);
    }

    private static class ThrowingActor
    extends Actor {
        public Throwable throwable;
        public Throwable recordedFailure = null;

        public ThrowingActor(Throwable throwable) {
            this.throwable = throwable;
        }

        private void throwError() {
            this.actor.run(() -> LangUtil.rethrowUnchecked((Throwable)this.throwable));
        }

        protected void handleFailure(Throwable failure) {
            this.recordedFailure = failure;
        }
    }
}

