/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public class ActorBuilderTest {
    @Test
    void shouldBuildActor() {
        Actor actor = Actor.newActor().build();
        ((ObjectAssert)Assertions.assertThat((Object)actor).isNotNull()).isInstanceOf(Actor.class);
    }

    @Test
    void shouldSetActorName() {
        String actorName = "foo";
        Actor actor = Actor.newActor().name("foo").build();
        Assertions.assertThat((String)actor.getName()).isEqualTo("foo");
    }

    @Test
    void shouldCallOnActorStartedHandler() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference actorControlRef = new AtomicReference();
        ActorScheduler scheduler = ActorScheduler.newActorScheduler().build();
        scheduler.start();
        Actor actor = Actor.newActor().actorStartedHandler(c -> {
            actorControlRef.set(c);
            latch.countDown();
        }).build();
        scheduler.submitActor(actor);
        Assertions.assertThat((boolean)latch.await(5L, TimeUnit.SECONDS));
        Assertions.assertThat(actorControlRef.get()).isNotNull();
        Future stopFuture = scheduler.stop();
        Awaitility.await().until(stopFuture::isDone);
    }
}

