/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.management;

import io.camunda.zeebe.protocol.management.BackupListResponseDecoder;
import io.camunda.zeebe.protocol.management.BackupStatusCode;
import io.camunda.zeebe.protocol.management.MessageHeaderEncoder;
import io.camunda.zeebe.protocol.management.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class BackupListResponseEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 0;
    public static final int TEMPLATE_ID = 5;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "8.7.9";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final BackupListResponseEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;
    private final BackupsEncoder backups = new BackupsEncoder(this);

    public int sbeBlockLength() {
        return 0;
    }

    public int sbeTemplateId() {
        return 5;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public BackupListResponseEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 0);
        return this;
    }

    public BackupListResponseEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(0).templateId(5).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static long backupsId() {
        return 1L;
    }

    public BackupsEncoder backupsCount(int count) {
        this.backups.wrap(this.buffer, count);
        return this.backups;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        BackupListResponseDecoder decoder = new BackupListResponseDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 0, 0);
        return decoder.appendTo(builder);
    }

    public static final class BackupsEncoder {
        public static final int HEADER_SIZE = 8;
        private final BackupListResponseEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        BackupsEncoder(BackupListResponseEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 8);
            buffer.putShort(limit + 0, (short)11, BYTE_ORDER);
            buffer.putShort(limit + 2, (short)count, BYTE_ORDER);
        }

        public BackupsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + BackupsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putShort(this.initialLimit + 2, (short)this.count, BYTE_ORDER);
            return this.count;
        }

        public static int countMinValue() {
            return 0;
        }

        public static int countMaxValue() {
            return 65534;
        }

        public static int sbeHeaderSize() {
            return 8;
        }

        public static int sbeBlockLength() {
            return 11;
        }

        public static int backupIdId() {
            return 1;
        }

        public static int backupIdSinceVersion() {
            return 0;
        }

        public static int backupIdEncodingOffset() {
            return 0;
        }

        public static int backupIdEncodingLength() {
            return 8;
        }

        public static String backupIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long backupIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long backupIdMinValue() {
            return -9223372036854775807L;
        }

        public static long backupIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public BackupsEncoder backupId(long value) {
            this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
            return this;
        }

        public static int statusId() {
            return 2;
        }

        public static int statusSinceVersion() {
            return 0;
        }

        public static int statusEncodingOffset() {
            return 8;
        }

        public static int statusEncodingLength() {
            return 1;
        }

        public static String statusMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public BackupsEncoder status(BackupStatusCode value) {
            this.buffer.putByte(this.offset + 8, (byte)value.value());
            return this;
        }

        public static int partitionIdId() {
            return 3;
        }

        public static int partitionIdSinceVersion() {
            return 0;
        }

        public static int partitionIdEncodingOffset() {
            return 9;
        }

        public static int partitionIdEncodingLength() {
            return 2;
        }

        public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int partitionIdNullValue() {
            return 65535;
        }

        public static int partitionIdMinValue() {
            return 0;
        }

        public static int partitionIdMaxValue() {
            return 65534;
        }

        public BackupsEncoder partitionId(int value) {
            this.buffer.putShort(this.offset + 9, (short)value, BYTE_ORDER);
            return this;
        }

        public static int failureReasonId() {
            return 8;
        }

        public static String failureReasonCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String failureReasonMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int failureReasonHeaderLength() {
            return 4;
        }

        public BackupsEncoder putFailureReason(DirectBuffer src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public BackupsEncoder putFailureReason(byte[] src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public BackupsEncoder failureReason(String value) {
            byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }

        public static int createdAtId() {
            return 9;
        }

        public static String createdAtCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String createdAtMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int createdAtHeaderLength() {
            return 4;
        }

        public BackupsEncoder putCreatedAt(DirectBuffer src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public BackupsEncoder putCreatedAt(byte[] src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public BackupsEncoder createdAt(String value) {
            byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }

        public static int brokerVersionId() {
            return 11;
        }

        public static String brokerVersionCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String brokerVersionMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int brokerVersionHeaderLength() {
            return 4;
        }

        public BackupsEncoder putBrokerVersion(DirectBuffer src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public BackupsEncoder putBrokerVersion(byte[] src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public BackupsEncoder brokerVersion(String value) {
            byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }
    }
}

