package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TimerRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTimerRecordValue.builder()}.
 */
@Generated(from = "TimerRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableTimerRecordValue.Builder.class)
public final class ImmutableTimerRecordValue
    implements TimerRecordValue {
  private final String tenantId;
  private final long processDefinitionKey;
  private final long elementInstanceKey;
  private final long processInstanceKey;
  private final long dueDate;
  private final String targetElementId;
  private final int repetitions;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableTimerRecordValue(
      String tenantId,
      long processDefinitionKey,
      long elementInstanceKey,
      long processInstanceKey,
      long dueDate,
      String targetElementId,
      int repetitions) {
    this.tenantId = tenantId;
    this.processDefinitionKey = processDefinitionKey;
    this.elementInstanceKey = elementInstanceKey;
    this.processInstanceKey = processInstanceKey;
    this.dueDate = dueDate;
    this.targetElementId = targetElementId;
    this.repetitions = repetitions;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the key of the process in which this timer was created
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   * @return the key of the related element instance.
   */
  @Override
  public long getElementInstanceKey() {
    return elementInstanceKey;
  }

  /**
   * @return the key of the related process instance
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * @return the due date of the timer as Unix timestamp in millis.
   */
  @Override
  public long getDueDate() {
    return dueDate;
  }

  /**
   * The handlerFlowNodeID property represent the ID, from the BPMN XML of the process, of the flow
   * node which will handle the timer trigger's event. In normal flow, this is usually the same as
   * the related activity's ID, but when the timer was created due to a boundary event, it will be
   * that event's ID.
   * @return the ID of the flow node which will handle the trigger element
   */
  @Override
  public String getTargetElementId() {
    return targetElementId;
  }

  /**
   * @return the number of times this timer should trigger
   */
  @Override
  public int getRepetitions() {
    return repetitions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TimerRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTimerRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableTimerRecordValue(
        value,
        this.processDefinitionKey,
        this.elementInstanceKey,
        this.processInstanceKey,
        this.dueDate,
        this.targetElementId,
        this.repetitions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TimerRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTimerRecordValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableTimerRecordValue(
        this.tenantId,
        value,
        this.elementInstanceKey,
        this.processInstanceKey,
        this.dueDate,
        this.targetElementId,
        this.repetitions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TimerRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTimerRecordValue withElementInstanceKey(long value) {
    if (this.elementInstanceKey == value) return this;
    return new ImmutableTimerRecordValue(
        this.tenantId,
        this.processDefinitionKey,
        value,
        this.processInstanceKey,
        this.dueDate,
        this.targetElementId,
        this.repetitions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TimerRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTimerRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableTimerRecordValue(
        this.tenantId,
        this.processDefinitionKey,
        this.elementInstanceKey,
        value,
        this.dueDate,
        this.targetElementId,
        this.repetitions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TimerRecordValue#getDueDate() dueDate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dueDate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTimerRecordValue withDueDate(long value) {
    if (this.dueDate == value) return this;
    return new ImmutableTimerRecordValue(
        this.tenantId,
        this.processDefinitionKey,
        this.elementInstanceKey,
        this.processInstanceKey,
        value,
        this.targetElementId,
        this.repetitions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TimerRecordValue#getTargetElementId() targetElementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetElementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTimerRecordValue withTargetElementId(String value) {
    if (Objects.equals(this.targetElementId, value)) return this;
    return new ImmutableTimerRecordValue(
        this.tenantId,
        this.processDefinitionKey,
        this.elementInstanceKey,
        this.processInstanceKey,
        this.dueDate,
        value,
        this.repetitions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TimerRecordValue#getRepetitions() repetitions} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repetitions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTimerRecordValue withRepetitions(int value) {
    if (this.repetitions == value) return this;
    return new ImmutableTimerRecordValue(
        this.tenantId,
        this.processDefinitionKey,
        this.elementInstanceKey,
        this.processInstanceKey,
        this.dueDate,
        this.targetElementId,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTimerRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTimerRecordValue
        && equalTo(0, (ImmutableTimerRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableTimerRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(tenantId, another.tenantId)
        && processDefinitionKey == another.processDefinitionKey
        && elementInstanceKey == another.elementInstanceKey
        && processInstanceKey == another.processInstanceKey
        && dueDate == another.dueDate
        && Objects.equals(targetElementId, another.targetElementId)
        && repetitions == another.repetitions;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code tenantId}, {@code processDefinitionKey}, {@code elementInstanceKey}, {@code processInstanceKey}, {@code dueDate}, {@code targetElementId}, {@code repetitions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    h += (h << 5) + Long.hashCode(elementInstanceKey);
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Long.hashCode(dueDate);
    h += (h << 5) + Objects.hashCode(targetElementId);
    h += (h << 5) + repetitions;
    return h;
  }

  /**
   * Prints the immutable value {@code TimerRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TimerRecordValue{"
        + "tenantId=" + tenantId
        + ", processDefinitionKey=" + processDefinitionKey
        + ", elementInstanceKey=" + elementInstanceKey
        + ", processInstanceKey=" + processInstanceKey
        + ", dueDate=" + dueDate
        + ", targetElementId=" + targetElementId
        + ", repetitions=" + repetitions
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link TimerRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TimerRecordValue instance
   */
  public static ImmutableTimerRecordValue copyOf(TimerRecordValue instance) {
    if (instance instanceof ImmutableTimerRecordValue) {
      return (ImmutableTimerRecordValue) instance;
    }
    return ImmutableTimerRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTimerRecordValue ImmutableTimerRecordValue}.
   * <pre>
   * ImmutableTimerRecordValue.builder()
   *    .withTenantId(String | null) // nullable {@link TimerRecordValue#getTenantId() tenantId}
   *    .withProcessDefinitionKey(long) // optional {@link TimerRecordValue#getProcessDefinitionKey() processDefinitionKey}
   *    .withElementInstanceKey(long) // optional {@link TimerRecordValue#getElementInstanceKey() elementInstanceKey}
   *    .withProcessInstanceKey(long) // optional {@link TimerRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withDueDate(long) // optional {@link TimerRecordValue#getDueDate() dueDate}
   *    .withTargetElementId(String | null) // nullable {@link TimerRecordValue#getTargetElementId() targetElementId}
   *    .withRepetitions(int) // optional {@link TimerRecordValue#getRepetitions() repetitions}
   *    .build();
   * </pre>
   * @return A new ImmutableTimerRecordValue builder
   */
  public static ImmutableTimerRecordValue.Builder builder() {
    return new ImmutableTimerRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTimerRecordValue ImmutableTimerRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TimerRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private String tenantId;
    private long processDefinitionKey;
    private long elementInstanceKey;
    private long processInstanceKey;
    private long dueDate;
    private String targetElementId;
    private int repetitions;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TimerRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TimerRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof TimerRecordValue) {
        TimerRecordValue instance = (TimerRecordValue) object;
        if ((bits & 0x1L) == 0) {
          this.withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
        this.withElementInstanceKey(instance.getElementInstanceKey());
        String targetElementIdValue = instance.getTargetElementId();
        if (targetElementIdValue != null) {
          withTargetElementId(targetElementIdValue);
        }
        this.withDueDate(instance.getDueDate());
        if ((bits & 0x2L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x2L;
        }
        this.withRepetitions(instance.getRepetitions());
        this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
      }
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          this.withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x2L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link TimerRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link TimerRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Initializes the value for the {@link TimerRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
     * @param elementInstanceKey The value for elementInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementInstanceKey(long elementInstanceKey) {
      this.elementInstanceKey = elementInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link TimerRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link TimerRecordValue#getDueDate() dueDate} attribute.
     * @param dueDate The value for dueDate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDueDate(long dueDate) {
      this.dueDate = dueDate;
      return this;
    }

    /**
     * Initializes the value for the {@link TimerRecordValue#getTargetElementId() targetElementId} attribute.
     * @param targetElementId The value for targetElementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTargetElementId(String targetElementId) {
      this.targetElementId = targetElementId;
      return this;
    }

    /**
     * Initializes the value for the {@link TimerRecordValue#getRepetitions() repetitions} attribute.
     * @param repetitions The value for repetitions 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withRepetitions(int repetitions) {
      this.repetitions = repetitions;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.tenantId = null;
      this.processDefinitionKey = 0;
      this.elementInstanceKey = 0;
      this.processInstanceKey = 0;
      this.dueDate = 0;
      this.targetElementId = null;
      this.repetitions = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTimerRecordValue ImmutableTimerRecordValue}.
     * @return An immutable instance of TimerRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTimerRecordValue build() {
      return new ImmutableTimerRecordValue(
          tenantId,
          processDefinitionKey,
          elementInstanceKey,
          processInstanceKey,
          dueDate,
          targetElementId,
          repetitions);
    }



  }



}
