package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AuthorizationRecordValue.PermissionValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePermissionValue.builder()}.
 */
@Generated(from = "AuthorizationRecordValue.PermissionValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutablePermissionValue.Builder.class)
public final class ImmutablePermissionValue
    implements AuthorizationRecordValue.PermissionValue {
  private final PermissionType permissionType;
  private final List<String> resourceIds;
  private transient int hashCode; // hashCode lazily computed

  private ImmutablePermissionValue(
      PermissionType permissionType,
      List<String> resourceIds) {
    this.permissionType = permissionType;
    this.resourceIds = resourceIds;
  }

  /**
   *Returns the type of permission for the resourceIds in this object 
   */
  @Override
  public PermissionType getPermissionType() {
    return permissionType;
  }

  /**
   *Returns the resourceIds of this permission 
   */
  @Override
  public List<String> getResourceIds() {
    return resourceIds;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthorizationRecordValue.PermissionValue#getPermissionType() permissionType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for permissionType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePermissionValue withPermissionType(PermissionType value) {
    if (this.permissionType == value) return this;
    return new ImmutablePermissionValue(value, this.resourceIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AuthorizationRecordValue.PermissionValue#getResourceIds() resourceIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePermissionValue withResourceIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutablePermissionValue(this.permissionType, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AuthorizationRecordValue.PermissionValue#getResourceIds() resourceIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of resourceIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePermissionValue withResourceIds(Iterable<String> elements) {
    if (this.resourceIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutablePermissionValue(this.permissionType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePermissionValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePermissionValue
        && equalTo(0, (ImmutablePermissionValue) another);
  }

  private boolean equalTo(int synthetic, ImmutablePermissionValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(permissionType, another.permissionType)
        && resourceIds.equals(another.resourceIds);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code permissionType}, {@code resourceIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(permissionType);
    h += (h << 5) + resourceIds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PermissionValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PermissionValue{"
        + "permissionType=" + permissionType
        + ", resourceIds=" + resourceIds
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link AuthorizationRecordValue.PermissionValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PermissionValue instance
   */
  public static ImmutablePermissionValue copyOf(AuthorizationRecordValue.PermissionValue instance) {
    if (instance instanceof ImmutablePermissionValue) {
      return (ImmutablePermissionValue) instance;
    }
    return ImmutablePermissionValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePermissionValue ImmutablePermissionValue}.
   * <pre>
   * ImmutablePermissionValue.builder()
   *    .withPermissionType(io.camunda.zeebe.protocol.record.value.PermissionType | null) // nullable {@link AuthorizationRecordValue.PermissionValue#getPermissionType() permissionType}
   *    .addResourceId|addAllResourceIds(String) // {@link AuthorizationRecordValue.PermissionValue#getResourceIds() resourceIds} elements
   *    .build();
   * </pre>
   * @return A new ImmutablePermissionValue builder
   */
  public static ImmutablePermissionValue.Builder builder() {
    return new ImmutablePermissionValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePermissionValue ImmutablePermissionValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AuthorizationRecordValue.PermissionValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private PermissionType permissionType;
    private List<String> resourceIds = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PermissionValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AuthorizationRecordValue.PermissionValue instance) {
      Objects.requireNonNull(instance, "instance");
      PermissionType permissionTypeValue = instance.getPermissionType();
      if (permissionTypeValue != null) {
        withPermissionType(permissionTypeValue);
      }
      addAllResourceIds(instance.getResourceIds());
      return this;
    }

    /**
     * Initializes the value for the {@link AuthorizationRecordValue.PermissionValue#getPermissionType() permissionType} attribute.
     * @param permissionType The value for permissionType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withPermissionType(PermissionType permissionType) {
      this.permissionType = permissionType;
      return this;
    }

    /**
     * Adds one element to {@link AuthorizationRecordValue.PermissionValue#getResourceIds() resourceIds} list.
     * @param element A resourceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addResourceId(String element) {
      this.resourceIds.add(element);
      return this;
    }

    /**
     * Adds elements to {@link AuthorizationRecordValue.PermissionValue#getResourceIds() resourceIds} list.
     * @param elements An array of resourceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addResourceIds(String... elements) {
      for (String element : elements) {
        this.resourceIds.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AuthorizationRecordValue.PermissionValue#getResourceIds() resourceIds} list.
     * @param elements An iterable of resourceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResourceIds(Iterable<String> elements) {
      this.resourceIds.clear();
      return addAllResourceIds(elements);
    }

    /**
     * Adds elements to {@link AuthorizationRecordValue.PermissionValue#getResourceIds() resourceIds} list.
     * @param elements An iterable of resourceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResourceIds(Iterable<String> elements) {
      for (String element : elements) {
        this.resourceIds.add(element);
      }
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.permissionType = null;
      this.resourceIds.clear();
      return this;
    }

    /**
     * Builds a new {@link ImmutablePermissionValue ImmutablePermissionValue}.
     * @return An immutable instance of PermissionValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePermissionValue build() {
      return new ImmutablePermissionValue(permissionType, createUnmodifiableList(true, resourceIds));
    }



  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }



}
