/*
 * Copyright © 2017 camunda services GmbH (info@camunda.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.camunda.zeebe.protocol.record.intent;

public enum MessageCorrelationIntent implements Intent {
  CORRELATE(1),
  CORRELATING(2),
  CORRELATED(3),
  NOT_CORRELATED(4);

  private final short value;

  MessageCorrelationIntent(final int value) {
    this.value = (short) value;
  }

  @Override
  public short value() {
    return value;
  }

  @Override
  public boolean isEvent() {
    switch (this) {
      case CORRELATING:
      case CORRELATED:
      case NOT_CORRELATED:
        return true;
      default:
        return false;
    }
  }

  public static Intent from(final short value) {
    switch (value) {
      case 1:
        return CORRELATE;
      case 2:
        return CORRELATING;
      case 3:
        return CORRELATED;
      case 4:
        return NOT_CORRELATED;
      default:
        return Intent.UNKNOWN;
    }
  }
}
