package io.camunda.zeebe.protocol.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FormMetadataValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormMetadataValue.builder()}.
 */
@Generated(from = "FormMetadataValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableFormMetadataValue.Builder.class)
public final class ImmutableFormMetadataValue
    implements FormMetadataValue {
  private final String tenantId;
  private final String formId;
  private final int version;
  private final String versionTag;
  private final long formKey;
  private final String resourceName;
  private final byte[] checksum;
  private final boolean duplicate;
  private final long deploymentKey;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableFormMetadataValue(
      String tenantId,
      String formId,
      int version,
      String versionTag,
      long formKey,
      String resourceName,
      byte[] checksum,
      boolean duplicate,
      long deploymentKey) {
    this.tenantId = tenantId;
    this.formId = formId;
    this.version = version;
    this.versionTag = versionTag;
    this.formKey = formKey;
    this.resourceName = resourceName;
    this.checksum = checksum;
    this.duplicate = duplicate;
    this.deploymentKey = deploymentKey;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the ID of the form
   */
  @Override
  public String getFormId() {
    return formId;
  }

  /**
   * @return the version of the deployed form
   */
  @Override
  public int getVersion() {
    return version;
  }

  /**
   * @return the custom version tag of the form
   */
  @Override
  public String getVersionTag() {
    return versionTag;
  }

  /**
   * @return the key of the deployed form
   */
  @Override
  public long getFormKey() {
    return formKey;
  }

  /**
   * @return the name of the resource through which this form was deployed
   */
  @Override
  public String getResourceName() {
    return resourceName;
  }

  /**
   * @return the checksum of the form resource (MD5)
   */
  @Override
  public byte[] getChecksum() {
    return checksum;
  }

  /**
   * @return {@code true} if the form is a duplicate (and has been deployed previously), otherwise
   *     {@code false}
   */
  @Override
  public boolean isDuplicate() {
    return duplicate;
  }

  /**
   * @return the key of the deployment this form was deployed with
   */
  @Override
  public long getDeploymentKey() {
    return deploymentKey;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormMetadataValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadataValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableFormMetadataValue(
        value,
        this.formId,
        this.version,
        this.versionTag,
        this.formKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormMetadataValue#getFormId() formId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadataValue withFormId(String value) {
    if (Objects.equals(this.formId, value)) return this;
    return new ImmutableFormMetadataValue(
        this.tenantId,
        value,
        this.version,
        this.versionTag,
        this.formKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormMetadataValue#getVersion() version} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadataValue withVersion(int value) {
    if (this.version == value) return this;
    return new ImmutableFormMetadataValue(
        this.tenantId,
        this.formId,
        value,
        this.versionTag,
        this.formKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormMetadataValue#getVersionTag() versionTag} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for versionTag (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadataValue withVersionTag(String value) {
    if (Objects.equals(this.versionTag, value)) return this;
    return new ImmutableFormMetadataValue(
        this.tenantId,
        this.formId,
        this.version,
        value,
        this.formKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormMetadataValue#getFormKey() formKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadataValue withFormKey(long value) {
    if (this.formKey == value) return this;
    return new ImmutableFormMetadataValue(
        this.tenantId,
        this.formId,
        this.version,
        this.versionTag,
        value,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormMetadataValue#getResourceName() resourceName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resourceName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadataValue withResourceName(String value) {
    if (Objects.equals(this.resourceName, value)) return this;
    return new ImmutableFormMetadataValue(
        this.tenantId,
        this.formId,
        this.version,
        this.versionTag,
        this.formKey,
        value,
        this.checksum,
        this.duplicate,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FormMetadataValue#getChecksum() checksum}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for checksum
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormMetadataValue withChecksum(byte... elements) {
    byte[] newValue = elements == null ? null : elements.clone();
    return new ImmutableFormMetadataValue(
        this.tenantId,
        this.formId,
        this.version,
        this.versionTag,
        this.formKey,
        this.resourceName,
        newValue,
        this.duplicate,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormMetadataValue#isDuplicate() duplicate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for duplicate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadataValue withDuplicate(boolean value) {
    if (this.duplicate == value) return this;
    return new ImmutableFormMetadataValue(
        this.tenantId,
        this.formId,
        this.version,
        this.versionTag,
        this.formKey,
        this.resourceName,
        this.checksum,
        value,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormMetadataValue#getDeploymentKey() deploymentKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deploymentKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadataValue withDeploymentKey(long value) {
    if (this.deploymentKey == value) return this;
    return new ImmutableFormMetadataValue(
        this.tenantId,
        this.formId,
        this.version,
        this.versionTag,
        this.formKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormMetadataValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormMetadataValue
        && equalTo(0, (ImmutableFormMetadataValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableFormMetadataValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(tenantId, another.tenantId)
        && Objects.equals(formId, another.formId)
        && version == another.version
        && Objects.equals(versionTag, another.versionTag)
        && formKey == another.formKey
        && Objects.equals(resourceName, another.resourceName)
        && Arrays.equals(checksum, another.checksum)
        && duplicate == another.duplicate
        && deploymentKey == another.deploymentKey;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code tenantId}, {@code formId}, {@code version}, {@code versionTag}, {@code formKey}, {@code resourceName}, {@code checksum}, {@code duplicate}, {@code deploymentKey}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Objects.hashCode(formId);
    h += (h << 5) + version;
    h += (h << 5) + Objects.hashCode(versionTag);
    h += (h << 5) + Long.hashCode(formKey);
    h += (h << 5) + Objects.hashCode(resourceName);
    h += (h << 5) + Arrays.hashCode(checksum);
    h += (h << 5) + Boolean.hashCode(duplicate);
    h += (h << 5) + Long.hashCode(deploymentKey);
    return h;
  }

  /**
   * Prints the immutable value {@code FormMetadataValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FormMetadataValue{"
        + "tenantId=" + tenantId
        + ", formId=" + formId
        + ", version=" + version
        + ", versionTag=" + versionTag
        + ", formKey=" + formKey
        + ", resourceName=" + resourceName
        + ", checksum=" + Arrays.toString(checksum)
        + ", duplicate=" + duplicate
        + ", deploymentKey=" + deploymentKey
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link FormMetadataValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormMetadataValue instance
   */
  public static ImmutableFormMetadataValue copyOf(FormMetadataValue instance) {
    if (instance instanceof ImmutableFormMetadataValue) {
      return (ImmutableFormMetadataValue) instance;
    }
    return ImmutableFormMetadataValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormMetadataValue ImmutableFormMetadataValue}.
   * <pre>
   * ImmutableFormMetadataValue.builder()
   *    .withTenantId(String | null) // nullable {@link FormMetadataValue#getTenantId() tenantId}
   *    .withFormId(String | null) // nullable {@link FormMetadataValue#getFormId() formId}
   *    .withVersion(int) // optional {@link FormMetadataValue#getVersion() version}
   *    .withVersionTag(String | null) // nullable {@link FormMetadataValue#getVersionTag() versionTag}
   *    .withFormKey(long) // optional {@link FormMetadataValue#getFormKey() formKey}
   *    .withResourceName(String | null) // nullable {@link FormMetadataValue#getResourceName() resourceName}
   *    .withChecksum(byte[] | null) // nullable {@link FormMetadataValue#getChecksum() checksum}
   *    .withDuplicate(boolean) // optional {@link FormMetadataValue#isDuplicate() duplicate}
   *    .withDeploymentKey(long) // optional {@link FormMetadataValue#getDeploymentKey() deploymentKey}
   *    .build();
   * </pre>
   * @return A new ImmutableFormMetadataValue builder
   */
  public static ImmutableFormMetadataValue.Builder builder() {
    return new ImmutableFormMetadataValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormMetadataValue ImmutableFormMetadataValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FormMetadataValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private String tenantId;
    private String formId;
    private int version;
    private String versionTag;
    private long formKey;
    private String resourceName;
    private byte[] checksum;
    private boolean duplicate;
    private long deploymentKey;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.deployment.FormMetadataValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FormMetadataValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof FormMetadataValue) {
        FormMetadataValue instance = (FormMetadataValue) object;
        String formIdValue = instance.getFormId();
        if (formIdValue != null) {
          withFormId(formIdValue);
        }
        this.withFormKey(instance.getFormKey());
        this.withDeploymentKey(instance.getDeploymentKey());
        if ((bits & 0x1L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x1L;
        }
        byte[] checksumValue = instance.getChecksum();
        if (checksumValue != null) {
          withChecksum(checksumValue);
        }
        String versionTagValue = instance.getVersionTag();
        if (versionTagValue != null) {
          withVersionTag(versionTagValue);
        }
        String resourceNameValue = instance.getResourceName();
        if (resourceNameValue != null) {
          withResourceName(resourceNameValue);
        }
        this.withDuplicate(instance.isDuplicate());
        this.withVersion(instance.getVersion());
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x1L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link FormMetadataValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link FormMetadataValue#getFormId() formId} attribute.
     * @param formId The value for formId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withFormId(String formId) {
      this.formId = formId;
      return this;
    }

    /**
     * Initializes the value for the {@link FormMetadataValue#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVersion(int version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link FormMetadataValue#getVersionTag() versionTag} attribute.
     * @param versionTag The value for versionTag (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVersionTag(String versionTag) {
      this.versionTag = versionTag;
      return this;
    }

    /**
     * Initializes the value for the {@link FormMetadataValue#getFormKey() formKey} attribute.
     * @param formKey The value for formKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withFormKey(long formKey) {
      this.formKey = formKey;
      return this;
    }

    /**
     * Initializes the value for the {@link FormMetadataValue#getResourceName() resourceName} attribute.
     * @param resourceName The value for resourceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResourceName(String resourceName) {
      this.resourceName = resourceName;
      return this;
    }

    /**
     * Initializes the value for the {@link FormMetadataValue#getChecksum() checksum} attribute.
     * @param checksum The elements for checksum
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withChecksum(byte... checksum) {
      this.checksum = checksum;
      return this;
    }

    /**
     * Initializes the value for the {@link FormMetadataValue#isDuplicate() duplicate} attribute.
     * @param duplicate The value for duplicate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDuplicate(boolean duplicate) {
      this.duplicate = duplicate;
      return this;
    }

    /**
     * Initializes the value for the {@link FormMetadataValue#getDeploymentKey() deploymentKey} attribute.
     * @param deploymentKey The value for deploymentKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDeploymentKey(long deploymentKey) {
      this.deploymentKey = deploymentKey;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.tenantId = null;
      this.formId = null;
      this.version = 0;
      this.versionTag = null;
      this.formKey = 0;
      this.resourceName = null;
      this.checksum = null;
      this.duplicate = false;
      this.deploymentKey = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormMetadataValue ImmutableFormMetadataValue}.
     * @return An immutable instance of FormMetadataValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormMetadataValue build() {
      return new ImmutableFormMetadataValue(
          tenantId,
          formId,
          version,
          versionTag,
          formKey,
          resourceName,
          checksum,
          duplicate,
          deploymentKey);
    }



  }



}
