package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AuthorizationRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAuthorizationRecordValue.builder()}.
 */
@Generated(from = "AuthorizationRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableAuthorizationRecordValue.Builder.class)
public final class ImmutableAuthorizationRecordValue
    implements AuthorizationRecordValue {
  private final PermissionAction action;
  private final Long ownerKey;
  private final AuthorizationOwnerType ownerType;
  private final AuthorizationResourceType resourceType;
  private final List<AuthorizationRecordValue.PermissionValue> permissions;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableAuthorizationRecordValue(
      PermissionAction action,
      Long ownerKey,
      AuthorizationOwnerType ownerType,
      AuthorizationResourceType resourceType,
      List<AuthorizationRecordValue.PermissionValue> permissions) {
    this.action = action;
    this.ownerKey = ownerKey;
    this.ownerType = ownerType;
    this.resourceType = resourceType;
    this.permissions = permissions;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @Override
  public PermissionAction getAction() {
    return action;
  }

  /**
   * @return The value of the {@code ownerKey} attribute
   */
  @Override
  public Long getOwnerKey() {
    return ownerKey;
  }

  /**
   * @return The value of the {@code ownerType} attribute
   */
  @Override
  public AuthorizationOwnerType getOwnerType() {
    return ownerType;
  }

  /**
   * @return The value of the {@code resourceType} attribute
   */
  @Override
  public AuthorizationResourceType getResourceType() {
    return resourceType;
  }

  /**
   * @return The value of the {@code permissions} attribute
   */
  @Override
  public List<AuthorizationRecordValue.PermissionValue> getPermissions() {
    return permissions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthorizationRecordValue#getAction() action} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthorizationRecordValue withAction(PermissionAction value) {
    if (this.action == value) return this;
    return new ImmutableAuthorizationRecordValue(value, this.ownerKey, this.ownerType, this.resourceType, this.permissions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthorizationRecordValue#getOwnerKey() ownerKey} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ownerKey (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthorizationRecordValue withOwnerKey(Long value) {
    if (Objects.equals(this.ownerKey, value)) return this;
    return new ImmutableAuthorizationRecordValue(this.action, value, this.ownerType, this.resourceType, this.permissions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthorizationRecordValue#getOwnerType() ownerType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ownerType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthorizationRecordValue withOwnerType(AuthorizationOwnerType value) {
    if (this.ownerType == value) return this;
    return new ImmutableAuthorizationRecordValue(this.action, this.ownerKey, value, this.resourceType, this.permissions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthorizationRecordValue#getResourceType() resourceType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resourceType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthorizationRecordValue withResourceType(AuthorizationResourceType value) {
    if (this.resourceType == value) return this;
    return new ImmutableAuthorizationRecordValue(this.action, this.ownerKey, this.ownerType, value, this.permissions);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AuthorizationRecordValue#getPermissions() permissions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAuthorizationRecordValue withPermissions(AuthorizationRecordValue.PermissionValue... elements) {
    List<AuthorizationRecordValue.PermissionValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableAuthorizationRecordValue(this.action, this.ownerKey, this.ownerType, this.resourceType, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AuthorizationRecordValue#getPermissions() permissions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of permissions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAuthorizationRecordValue withPermissions(Iterable<? extends AuthorizationRecordValue.PermissionValue> elements) {
    if (this.permissions == elements) return this;
    List<AuthorizationRecordValue.PermissionValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableAuthorizationRecordValue(this.action, this.ownerKey, this.ownerType, this.resourceType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAuthorizationRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAuthorizationRecordValue
        && equalTo(0, (ImmutableAuthorizationRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableAuthorizationRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(action, another.action)
        && Objects.equals(ownerKey, another.ownerKey)
        && Objects.equals(ownerType, another.ownerType)
        && Objects.equals(resourceType, another.resourceType)
        && permissions.equals(another.permissions);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code action}, {@code ownerKey}, {@code ownerType}, {@code resourceType}, {@code permissions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(ownerKey);
    h += (h << 5) + Objects.hashCode(ownerType);
    h += (h << 5) + Objects.hashCode(resourceType);
    h += (h << 5) + permissions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AuthorizationRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AuthorizationRecordValue{"
        + "action=" + action
        + ", ownerKey=" + ownerKey
        + ", ownerType=" + ownerType
        + ", resourceType=" + resourceType
        + ", permissions=" + permissions
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link AuthorizationRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AuthorizationRecordValue instance
   */
  public static ImmutableAuthorizationRecordValue copyOf(AuthorizationRecordValue instance) {
    if (instance instanceof ImmutableAuthorizationRecordValue) {
      return (ImmutableAuthorizationRecordValue) instance;
    }
    return ImmutableAuthorizationRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAuthorizationRecordValue ImmutableAuthorizationRecordValue}.
   * <pre>
   * ImmutableAuthorizationRecordValue.builder()
   *    .withAction(io.camunda.zeebe.protocol.record.value.PermissionAction | null) // nullable {@link AuthorizationRecordValue#getAction() action}
   *    .withOwnerKey(Long | null) // nullable {@link AuthorizationRecordValue#getOwnerKey() ownerKey}
   *    .withOwnerType(io.camunda.zeebe.protocol.record.value.AuthorizationOwnerType | null) // nullable {@link AuthorizationRecordValue#getOwnerType() ownerType}
   *    .withResourceType(io.camunda.zeebe.protocol.record.value.AuthorizationResourceType | null) // nullable {@link AuthorizationRecordValue#getResourceType() resourceType}
   *    .addPermission|addAllPermissions(io.camunda.zeebe.protocol.record.value.AuthorizationRecordValue.PermissionValue) // {@link AuthorizationRecordValue#getPermissions() permissions} elements
   *    .build();
   * </pre>
   * @return A new ImmutableAuthorizationRecordValue builder
   */
  public static ImmutableAuthorizationRecordValue.Builder builder() {
    return new ImmutableAuthorizationRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAuthorizationRecordValue ImmutableAuthorizationRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AuthorizationRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private PermissionAction action;
    private Long ownerKey;
    private AuthorizationOwnerType ownerType;
    private AuthorizationResourceType resourceType;
    private List<ImmutablePermissionValue.Builder> permissions = new ArrayList<ImmutablePermissionValue.Builder>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AuthorizationRecordValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AuthorizationRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      PermissionAction actionValue = instance.getAction();
      if (actionValue != null) {
        withAction(actionValue);
      }
      Long ownerKeyValue = instance.getOwnerKey();
      if (ownerKeyValue != null) {
        withOwnerKey(ownerKeyValue);
      }
      AuthorizationOwnerType ownerTypeValue = instance.getOwnerType();
      if (ownerTypeValue != null) {
        withOwnerType(ownerTypeValue);
      }
      AuthorizationResourceType resourceTypeValue = instance.getResourceType();
      if (resourceTypeValue != null) {
        withResourceType(resourceTypeValue);
      }
      addAllPermissions(instance.getPermissions());
      return this;
    }

    /**
     * Initializes the value for the {@link AuthorizationRecordValue#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withAction(PermissionAction action) {
      this.action = action;
      return this;
    }

    /**
     * Initializes the value for the {@link AuthorizationRecordValue#getOwnerKey() ownerKey} attribute.
     * @param ownerKey The value for ownerKey (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withOwnerKey(Long ownerKey) {
      this.ownerKey = ownerKey;
      return this;
    }

    /**
     * Initializes the value for the {@link AuthorizationRecordValue#getOwnerType() ownerType} attribute.
     * @param ownerType The value for ownerType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withOwnerType(AuthorizationOwnerType ownerType) {
      this.ownerType = ownerType;
      return this;
    }

    /**
     * Initializes the value for the {@link AuthorizationRecordValue#getResourceType() resourceType} attribute.
     * @param resourceType The value for resourceType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResourceType(AuthorizationResourceType resourceType) {
      this.resourceType = resourceType;
      return this;
    }

    /**
     * Adds one element to {@link AuthorizationRecordValue#getPermissions() permissions} list.
     * @param element A permissions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPermission(AuthorizationRecordValue.PermissionValue element) {
      if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue(element);
      this.permissions.add(ImmutablePermissionValue.builder().from(element));
      return this;
    }

    /**
     * Adds elements to {@link AuthorizationRecordValue#getPermissions() permissions} list.
     * @param elements An array of permissions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPermissions(AuthorizationRecordValue.PermissionValue... elements) {
      for (AuthorizationRecordValue.PermissionValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue(element);
        this.permissions.add(ImmutablePermissionValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds a new builder to the {@link AuthorizationRecordValue#getPermissions() permissions} list and returns
     * the builder.
     */
    public final ImmutablePermissionValue.Builder addPermissionBuilder() {
      ImmutablePermissionValue.Builder builder = ImmutablePermissionValue.builder();
      this.permissions.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link AuthorizationRecordValue#getPermissions() permissions} list.
     * @param elements An array of permissions builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPermissionBuilders(ImmutablePermissionValue.Builder... elements) {
      for (ImmutablePermissionValue.Builder element : elements) {
        this.permissions.add(element);
      }
      return this;
    }

    /**
     * Gets the builder elements to {@link AuthorizationRecordValue#getPermissions() permissions} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<ImmutablePermissionValue.Builder> permissionBuilders() {
      return createUnmodifiableList(false, this.permissions);
    }

    /**
     * Sets or replaces all elements for {@link AuthorizationRecordValue#getPermissions() permissions} list.
     * @param elements An iterable of permissions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withPermissions(Iterable<? extends AuthorizationRecordValue.PermissionValue> elements) {
      this.permissions.clear();
      return addAllPermissions(elements);
    }

    /**
     * Adds elements to {@link AuthorizationRecordValue#getPermissions() permissions} list.
     * @param elements An iterable of permissions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPermissions(Iterable<? extends AuthorizationRecordValue.PermissionValue> elements) {
      for (AuthorizationRecordValue.PermissionValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue(element);
        this.permissions.add(ImmutablePermissionValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds elements to {@link AuthorizationRecordValue#getPermissions() permissions} list.
     * @param elements An iterable of permissions builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPermissionBuilders(Iterable<ImmutablePermissionValue.Builder> elements) {
      for (ImmutablePermissionValue.Builder element : elements) {
        this.permissions.add(element);
      }
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.action = null;
      this.ownerKey = null;
      this.ownerType = null;
      this.resourceType = null;
      this.permissions.clear();
      return this;
    }

    /**
     * Builds a new {@link ImmutableAuthorizationRecordValue ImmutableAuthorizationRecordValue}.
     * @return An immutable instance of AuthorizationRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAuthorizationRecordValue build() {
      return new ImmutableAuthorizationRecordValue(
          action,
          ownerKey,
          ownerType,
          resourceType,
          createUnmodifiableList(true, convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue(permissions)));
    }



    
    private static ImmutablePermissionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue( ImmutablePermissionValue.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    
    private static AuthorizationRecordValue.PermissionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue( AuthorizationRecordValue.PermissionValue value) {
      if (value == null) return null;
      return ImmutablePermissionValue.builder().from(value).build();
    }

    
    private static ImmutablePermissionValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue( AuthorizationRecordValue.PermissionValue value) {
      if (value == null) return null;
      return ImmutablePermissionValue.builder().from(value);
    }

    private static List<AuthorizationRecordValue.PermissionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue(Iterable<? extends ImmutablePermissionValue.Builder> builderList) {
      ArrayList<AuthorizationRecordValue.PermissionValue> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
        list = new ArrayList<>(size);
      } else {
        list = new ArrayList<>();
      }
      for (ImmutablePermissionValue.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<AuthorizationRecordValue.PermissionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue(ImmutablePermissionValue.Builder... builderArray) {
      ArrayList<AuthorizationRecordValue.PermissionValue> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>(builderArray.length);
      for (ImmutablePermissionValue.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ImmutablePermissionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue(Iterable<? extends ImmutablePermissionValue> valueList) {
      ArrayList<ImmutablePermissionValue.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
        list = new ArrayList<>(size);
      } else {
        list = new ArrayList<>();
      }
      for (ImmutablePermissionValue element : valueList) {
        list.add(ImmutablePermissionValue.builder().from(element));
      }
      return list;
    }

    private static List<ImmutablePermissionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue(ImmutablePermissionValue... valueArray) {
      ArrayList<ImmutablePermissionValue.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>(valueArray.length);
      for (ImmutablePermissionValue element : valueArray) {
        list.add(ImmutablePermissionValue.builder().from(element));
      }
      return list;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }



  
  private static ImmutablePermissionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue( ImmutablePermissionValue.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  
  private static AuthorizationRecordValue.PermissionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue( AuthorizationRecordValue.PermissionValue value) {
    if (value == null) return null;
    return ImmutablePermissionValue.builder().from(value).build();
  }

  
  private static ImmutablePermissionValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue( AuthorizationRecordValue.PermissionValue value) {
    if (value == null) return null;
    return ImmutablePermissionValue.builder().from(value);
  }

  private static List<AuthorizationRecordValue.PermissionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue(Iterable<? extends ImmutablePermissionValue.Builder> builderList) {
    ArrayList<AuthorizationRecordValue.PermissionValue> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (ImmutablePermissionValue.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<AuthorizationRecordValue.PermissionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue(ImmutablePermissionValue.Builder... builderArray) {
    ArrayList<AuthorizationRecordValue.PermissionValue> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>(builderArray.length);
    for (ImmutablePermissionValue.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ImmutablePermissionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue(Iterable<? extends ImmutablePermissionValue> valueList) {
    ArrayList<ImmutablePermissionValue.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (ImmutablePermissionValue element : valueList) {
      list.add(ImmutablePermissionValue.builder().from(element));
    }
    return list;
  }

  private static List<ImmutablePermissionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutablePermissionValue(ImmutablePermissionValue... valueArray) {
    ArrayList<ImmutablePermissionValue.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>(valueArray.length);
    for (ImmutablePermissionValue element : valueArray) {
      list.add(ImmutablePermissionValue.builder().from(element));
    }
    return list;
  }
}
