/*
 * Copyright © 2017 camunda services GmbH (info@camunda.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.camunda.zeebe.protocol.record.value;

import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValue;
import org.immutables.value.Value;

/**
 * DeploymentDistributionRecordValue is deprecated as of 8.2.0. A generalised way of distributing
 * commands has been introduced in this version. Distribution should now be handled using the {@link
 * CommandDistributionRecordValue}. This record value only remains to stay backwards compatible.
 */
@Value.Immutable
@ImmutableProtocol(builder = ImmutableDeploymentDistributionRecordValue.Builder.class)
@Deprecated
public interface DeploymentDistributionRecordValue extends RecordValue {

  /**
   * @return the partition where the deployment should be distributed
   */
  int getPartitionId();
}
