/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.ImmutableRecordValue;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.CommandDistributionRecordValue;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="CommandDistributionRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableCommandDistributionRecordValue
implements CommandDistributionRecordValue {
    private final int partitionId;
    private final ValueType valueType;
    private final Intent intent;
    private final ImmutableRecordValue commandValue;
    private transient int hashCode;

    private ImmutableCommandDistributionRecordValue(int partitionId, ValueType valueType, Intent intent, ImmutableRecordValue commandValue) {
        this.partitionId = partitionId;
        this.valueType = valueType;
        this.intent = intent;
        this.commandValue = commandValue;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public Intent getIntent() {
        return this.intent;
    }

    @Override
    public ImmutableRecordValue getCommandValue() {
        return this.commandValue;
    }

    public final ImmutableCommandDistributionRecordValue withPartitionId(int value) {
        if (this.partitionId == value) {
            return this;
        }
        return new ImmutableCommandDistributionRecordValue(value, this.valueType, this.intent, this.commandValue);
    }

    public final ImmutableCommandDistributionRecordValue withValueType(ValueType value) {
        if (this.valueType == value) {
            return this;
        }
        return new ImmutableCommandDistributionRecordValue(this.partitionId, value, this.intent, this.commandValue);
    }

    public final ImmutableCommandDistributionRecordValue withIntent(Intent value) {
        if (this.intent == value) {
            return this;
        }
        return new ImmutableCommandDistributionRecordValue(this.partitionId, this.valueType, value, this.commandValue);
    }

    public final ImmutableCommandDistributionRecordValue withCommandValue(RecordValue value) {
        if (this.commandValue == value) {
            return this;
        }
        ImmutableRecordValue newValue = ImmutableRecordValue.builder().from(value).build();
        return new ImmutableCommandDistributionRecordValue(this.partitionId, this.valueType, this.intent, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommandDistributionRecordValue && this.equalTo(0, (ImmutableCommandDistributionRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommandDistributionRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.partitionId == another.partitionId && Objects.equals((Object)this.valueType, (Object)another.valueType) && Objects.equals(this.intent, another.intent) && Objects.equals(this.commandValue, another.commandValue);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.partitionId;
        h += (h << 5) + Objects.hashCode((Object)this.valueType);
        h += (h << 5) + Objects.hashCode(this.intent);
        h += (h << 5) + Objects.hashCode(this.commandValue);
        return h;
    }

    public String toString() {
        return "CommandDistributionRecordValue{partitionId=" + this.partitionId + ", valueType=" + (Object)((Object)this.valueType) + ", intent=" + this.intent + ", commandValue=" + this.commandValue + "}";
    }

    public static ImmutableCommandDistributionRecordValue copyOf(CommandDistributionRecordValue instance) {
        if (instance instanceof ImmutableCommandDistributionRecordValue) {
            return (ImmutableCommandDistributionRecordValue)instance;
        }
        return ImmutableCommandDistributionRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static ImmutableRecordValue convertToValueTypeio_camunda_zeebe_protocol_record_ImmutableRecordValue(ImmutableRecordValue.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    private static RecordValue convertToValueTypeio_camunda_zeebe_protocol_record_ImmutableRecordValue(RecordValue value) {
        if (value == null) {
            return null;
        }
        return ImmutableRecordValue.builder().from(value).build();
    }

    private static ImmutableRecordValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_ImmutableRecordValue(RecordValue value) {
        if (value == null) {
            return null;
        }
        return ImmutableRecordValue.builder().from(value);
    }

    @ImmutableProtocol.Builder
    @Generated(from="CommandDistributionRecordValue", generator="Immutables")
    public static final class Builder {
        private int partitionId;
        private ValueType valueType;
        private Intent intent;
        private ImmutableRecordValue.Builder commandValue;

        private Builder() {
        }

        public final Builder from(CommandDistributionRecordValue instance) {
            RecordValue commandValueValue;
            Intent intentValue;
            Objects.requireNonNull(instance, "instance");
            this.withPartitionId(instance.getPartitionId());
            ValueType valueTypeValue = instance.getValueType();
            if (valueTypeValue != null) {
                this.withValueType(valueTypeValue);
            }
            if ((intentValue = instance.getIntent()) != null) {
                this.withIntent(intentValue);
            }
            if ((commandValueValue = instance.getCommandValue()) != null) {
                this.withCommandValue(commandValueValue);
            }
            return this;
        }

        public final Builder withPartitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public final Builder withValueType(ValueType valueType) {
            this.valueType = valueType;
            return this;
        }

        public final Builder withIntent(Intent intent) {
            this.intent = intent;
            return this;
        }

        public final Builder withCommandValue(RecordValue commandValue) {
            this.commandValue = ImmutableRecordValue.builder().from(commandValue == null ? null : Builder.convertToValueTypeio_camunda_zeebe_protocol_record_ImmutableRecordValue(commandValue));
            return this;
        }

        public final ImmutableRecordValue.Builder commandValueBuilder() {
            if (this.commandValue == null) {
                this.commandValue = ImmutableRecordValue.builder();
            }
            return this.commandValue;
        }

        public final Builder commandValueBuilder(ImmutableRecordValue.Builder commandValue) {
            this.commandValue = commandValue;
            return this;
        }

        public Builder clear() {
            this.partitionId = 0;
            this.valueType = null;
            this.intent = null;
            this.commandValue = null;
            return this;
        }

        public ImmutableCommandDistributionRecordValue build() {
            return new ImmutableCommandDistributionRecordValue(this.partitionId, this.valueType, this.intent, this.commandValue == null ? null : Builder.convertToValueTypeio_camunda_zeebe_protocol_record_ImmutableRecordValue(this.commandValue));
        }

        private static ImmutableRecordValue convertToValueTypeio_camunda_zeebe_protocol_record_ImmutableRecordValue(ImmutableRecordValue.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        private static RecordValue convertToValueTypeio_camunda_zeebe_protocol_record_ImmutableRecordValue(RecordValue value) {
            if (value == null) {
                return null;
            }
            return ImmutableRecordValue.builder().from(value).build();
        }

        private static ImmutableRecordValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_ImmutableRecordValue(RecordValue value) {
            if (value == null) {
                return null;
            }
            return ImmutableRecordValue.builder().from(value);
        }
    }
}

