/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="Record", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableRecord<T extends RecordValue>
implements Record<T> {
    private final long position;
    private final long sourceRecordPosition;
    private final long key;
    private final long timestamp;
    private final Intent intent;
    private final int partitionId;
    private final RecordType recordType;
    private final RejectionType rejectionType;
    private final String rejectionReason;
    private final String brokerVersion;
    private final Map<String, Object> authorizations;
    private final int recordVersion;
    private final ValueType valueType;
    private final T value;
    private transient int hashCode;

    private ImmutableRecord(long position, long sourceRecordPosition, long key, long timestamp, Intent intent, int partitionId, RecordType recordType, RejectionType rejectionType, String rejectionReason, String brokerVersion, Map<String, Object> authorizations, int recordVersion, ValueType valueType, T value) {
        this.position = position;
        this.sourceRecordPosition = sourceRecordPosition;
        this.key = key;
        this.timestamp = timestamp;
        this.intent = intent;
        this.partitionId = partitionId;
        this.recordType = recordType;
        this.rejectionType = rejectionType;
        this.rejectionReason = rejectionReason;
        this.brokerVersion = brokerVersion;
        this.authorizations = authorizations;
        this.recordVersion = recordVersion;
        this.valueType = valueType;
        this.value = value;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public long getSourceRecordPosition() {
        return this.sourceRecordPosition;
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Intent getIntent() {
        return this.intent;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public RecordType getRecordType() {
        return this.recordType;
    }

    @Override
    public RejectionType getRejectionType() {
        return this.rejectionType;
    }

    @Override
    public String getRejectionReason() {
        return this.rejectionReason;
    }

    @Override
    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    @Override
    public Map<String, Object> getAuthorizations() {
        return this.authorizations;
    }

    @Override
    public int getRecordVersion() {
        return this.recordVersion;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public final ImmutableRecord<T> withPosition(long value) {
        if (this.position == value) {
            return this;
        }
        return new ImmutableRecord<T>(value, this.sourceRecordPosition, this.key, this.timestamp, this.intent, this.partitionId, this.recordType, this.rejectionType, this.rejectionReason, this.brokerVersion, this.authorizations, this.recordVersion, this.valueType, this.value);
    }

    public final ImmutableRecord<T> withSourceRecordPosition(long value) {
        if (this.sourceRecordPosition == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, value, this.key, this.timestamp, this.intent, this.partitionId, this.recordType, this.rejectionType, this.rejectionReason, this.brokerVersion, this.authorizations, this.recordVersion, this.valueType, this.value);
    }

    public final ImmutableRecord<T> withKey(long value) {
        if (this.key == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, value, this.timestamp, this.intent, this.partitionId, this.recordType, this.rejectionType, this.rejectionReason, this.brokerVersion, this.authorizations, this.recordVersion, this.valueType, this.value);
    }

    public final ImmutableRecord<T> withTimestamp(long value) {
        if (this.timestamp == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, value, this.intent, this.partitionId, this.recordType, this.rejectionType, this.rejectionReason, this.brokerVersion, this.authorizations, this.recordVersion, this.valueType, this.value);
    }

    public final ImmutableRecord<T> withIntent(Intent value) {
        if (this.intent == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, value, this.partitionId, this.recordType, this.rejectionType, this.rejectionReason, this.brokerVersion, this.authorizations, this.recordVersion, this.valueType, this.value);
    }

    public final ImmutableRecord<T> withPartitionId(int value) {
        if (this.partitionId == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.intent, value, this.recordType, this.rejectionType, this.rejectionReason, this.brokerVersion, this.authorizations, this.recordVersion, this.valueType, this.value);
    }

    public final ImmutableRecord<T> withRecordType(RecordType value) {
        if (this.recordType == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.intent, this.partitionId, value, this.rejectionType, this.rejectionReason, this.brokerVersion, this.authorizations, this.recordVersion, this.valueType, this.value);
    }

    public final ImmutableRecord<T> withRejectionType(RejectionType value) {
        if (this.rejectionType == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.intent, this.partitionId, this.recordType, value, this.rejectionReason, this.brokerVersion, this.authorizations, this.recordVersion, this.valueType, this.value);
    }

    public final ImmutableRecord<T> withRejectionReason(String value) {
        if (Objects.equals(this.rejectionReason, value)) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.intent, this.partitionId, this.recordType, this.rejectionType, value, this.brokerVersion, this.authorizations, this.recordVersion, this.valueType, this.value);
    }

    public final ImmutableRecord<T> withBrokerVersion(String value) {
        if (Objects.equals(this.brokerVersion, value)) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.intent, this.partitionId, this.recordType, this.rejectionType, this.rejectionReason, value, this.authorizations, this.recordVersion, this.valueType, this.value);
    }

    public final ImmutableRecord<T> withAuthorizations(Map<String, ? extends Object> entries) {
        if (this.authorizations == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableRecord.createUnmodifiableMap(false, false, entries);
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.intent, this.partitionId, this.recordType, this.rejectionType, this.rejectionReason, this.brokerVersion, newValue, this.recordVersion, this.valueType, this.value);
    }

    public final ImmutableRecord<T> withRecordVersion(int value) {
        if (this.recordVersion == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.intent, this.partitionId, this.recordType, this.rejectionType, this.rejectionReason, this.brokerVersion, this.authorizations, value, this.valueType, this.value);
    }

    public final ImmutableRecord<T> withValueType(ValueType value) {
        if (this.valueType == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.intent, this.partitionId, this.recordType, this.rejectionType, this.rejectionReason, this.brokerVersion, this.authorizations, this.recordVersion, value, this.value);
    }

    public final ImmutableRecord<T> withValue(T value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.intent, this.partitionId, this.recordType, this.rejectionType, this.rejectionReason, this.brokerVersion, this.authorizations, this.recordVersion, this.valueType, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRecord && this.equalTo(0, (ImmutableRecord)another);
    }

    private boolean equalTo(int synthetic, ImmutableRecord<?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.position == another.position && this.sourceRecordPosition == another.sourceRecordPosition && this.key == another.key && this.timestamp == another.timestamp && Objects.equals(this.intent, another.intent) && this.partitionId == another.partitionId && Objects.equals((Object)this.recordType, (Object)another.recordType) && Objects.equals((Object)this.rejectionType, (Object)another.rejectionType) && Objects.equals(this.rejectionReason, another.rejectionReason) && Objects.equals(this.brokerVersion, another.brokerVersion) && this.authorizations.equals(another.authorizations) && this.recordVersion == another.recordVersion && Objects.equals((Object)this.valueType, (Object)another.valueType) && Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.position);
        h += (h << 5) + Long.hashCode(this.sourceRecordPosition);
        h += (h << 5) + Long.hashCode(this.key);
        h += (h << 5) + Long.hashCode(this.timestamp);
        h += (h << 5) + Objects.hashCode(this.intent);
        h += (h << 5) + this.partitionId;
        h += (h << 5) + Objects.hashCode((Object)this.recordType);
        h += (h << 5) + Objects.hashCode((Object)this.rejectionType);
        h += (h << 5) + Objects.hashCode(this.rejectionReason);
        h += (h << 5) + Objects.hashCode(this.brokerVersion);
        h += (h << 5) + this.authorizations.hashCode();
        h += (h << 5) + this.recordVersion;
        h += (h << 5) + Objects.hashCode((Object)this.valueType);
        h += (h << 5) + Objects.hashCode(this.value);
        return h;
    }

    public String toString() {
        return "Record{position=" + this.position + ", sourceRecordPosition=" + this.sourceRecordPosition + ", key=" + this.key + ", timestamp=" + this.timestamp + ", intent=" + this.intent + ", partitionId=" + this.partitionId + ", recordType=" + (Object)((Object)this.recordType) + ", rejectionType=" + (Object)((Object)this.rejectionType) + ", rejectionReason=" + this.rejectionReason + ", brokerVersion=" + this.brokerVersion + ", authorizations=" + this.authorizations + ", recordVersion=" + this.recordVersion + ", valueType=" + (Object)((Object)this.valueType) + ", value=" + this.value + "}";
    }

    public static <T extends RecordValue> ImmutableRecord<T> copyOf(Record<T> instance) {
        if (instance instanceof ImmutableRecord) {
            return (ImmutableRecord)instance;
        }
        return ImmutableRecord.builder().from(instance).build();
    }

    public static <T extends RecordValue> Builder<T> builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    /* synthetic */ ImmutableRecord(long x0, long x1, long x2, long x3, Intent x4, int x5, RecordType x6, RejectionType x7, String x8, String x9, Map x10, int x11, ValueType x12, RecordValue x13, 1 x14) {
        this(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13);
    }

    @ImmutableProtocol.Builder
    @Generated(from="Record", generator="Immutables")
    public static final class Builder<T extends RecordValue> {
        private long position;
        private long sourceRecordPosition;
        private long key;
        private long timestamp;
        private Intent intent;
        private int partitionId;
        private RecordType recordType;
        private RejectionType rejectionType;
        private String rejectionReason;
        private String brokerVersion;
        private Map<String, Object> authorizations = new LinkedHashMap<String, Object>();
        private int recordVersion;
        private ValueType valueType;
        private T value;

        private Builder() {
        }

        public final Builder<T> from(Record<T> instance) {
            T valueValue;
            String brokerVersionValue;
            String rejectionReasonValue;
            RejectionType rejectionTypeValue;
            Objects.requireNonNull(instance, "instance");
            this.withPosition(instance.getPosition());
            this.withSourceRecordPosition(instance.getSourceRecordPosition());
            this.withKey(instance.getKey());
            this.withTimestamp(instance.getTimestamp());
            Intent intentValue = instance.getIntent();
            if (intentValue != null) {
                this.withIntent(intentValue);
            }
            this.withPartitionId(instance.getPartitionId());
            RecordType recordTypeValue = instance.getRecordType();
            if (recordTypeValue != null) {
                this.withRecordType(recordTypeValue);
            }
            if ((rejectionTypeValue = instance.getRejectionType()) != null) {
                this.withRejectionType(rejectionTypeValue);
            }
            if ((rejectionReasonValue = instance.getRejectionReason()) != null) {
                this.withRejectionReason(rejectionReasonValue);
            }
            if ((brokerVersionValue = instance.getBrokerVersion()) != null) {
                this.withBrokerVersion(brokerVersionValue);
            }
            this.putAllAuthorizations(instance.getAuthorizations());
            this.withRecordVersion(instance.getRecordVersion());
            ValueType valueTypeValue = instance.getValueType();
            if (valueTypeValue != null) {
                this.withValueType(valueTypeValue);
            }
            if ((valueValue = instance.getValue()) != null) {
                this.withValue(valueValue);
            }
            return this;
        }

        public final Builder<T> withPosition(long position) {
            this.position = position;
            return this;
        }

        public final Builder<T> withSourceRecordPosition(long sourceRecordPosition) {
            this.sourceRecordPosition = sourceRecordPosition;
            return this;
        }

        public final Builder<T> withKey(long key) {
            this.key = key;
            return this;
        }

        public final Builder<T> withTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Builder<T> withIntent(Intent intent) {
            this.intent = intent;
            return this;
        }

        public final Builder<T> withPartitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public final Builder<T> withRecordType(RecordType recordType) {
            this.recordType = recordType;
            return this;
        }

        public final Builder<T> withRejectionType(RejectionType rejectionType) {
            this.rejectionType = rejectionType;
            return this;
        }

        public final Builder<T> withRejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
            return this;
        }

        public final Builder<T> withBrokerVersion(String brokerVersion) {
            this.brokerVersion = brokerVersion;
            return this;
        }

        public final Builder<T> putAuthorization(String key, Object value) {
            this.authorizations.put(key, value);
            return this;
        }

        public final Builder<T> putAuthorization(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.authorizations.put(k, v);
            return this;
        }

        public final Builder<T> withAuthorizations(Map<String, ? extends Object> entries) {
            this.authorizations.clear();
            return this.putAllAuthorizations(entries);
        }

        public final Builder<T> putAllAuthorizations(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.authorizations.put(k, v);
            }
            return this;
        }

        public final Builder<T> withRecordVersion(int recordVersion) {
            this.recordVersion = recordVersion;
            return this;
        }

        public final Builder<T> withValueType(ValueType valueType) {
            this.valueType = valueType;
            return this;
        }

        public final Builder<T> withValue(T value) {
            this.value = value;
            return this;
        }

        public Builder<T> clear() {
            this.position = 0L;
            this.sourceRecordPosition = 0L;
            this.key = 0L;
            this.timestamp = 0L;
            this.intent = null;
            this.partitionId = 0;
            this.recordType = null;
            this.rejectionType = null;
            this.rejectionReason = null;
            this.brokerVersion = null;
            this.authorizations.clear();
            this.recordVersion = 0;
            this.valueType = null;
            this.value = null;
            return this;
        }

        public ImmutableRecord<T> build() {
            return new ImmutableRecord(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.intent, this.partitionId, this.recordType, this.rejectionType, this.rejectionReason, this.brokerVersion, ImmutableRecord.createUnmodifiableMap(false, false, this.authorizations), this.recordVersion, this.valueType, (RecordValue)this.value, null);
        }
    }
}

