/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.encoding;

import io.camunda.zeebe.protocol.management.BackupRequestDecoder;
import io.camunda.zeebe.protocol.management.BackupRequestEncoder;
import io.camunda.zeebe.protocol.management.BackupRequestType;
import io.camunda.zeebe.protocol.management.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.management.MessageHeaderEncoder;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class BackupRequest
implements BufferReader,
BufferWriter {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final BackupRequestEncoder bodyEncoder = new BackupRequestEncoder();
    private final BackupRequestDecoder bodyDecoder = new BackupRequestDecoder();
    private BackupRequestType type;
    private int partitionId;
    private long backupId;

    public BackupRequest reset() {
        this.type = BackupRequestType.NULL_VAL;
        this.partitionId = BackupRequestEncoder.partitionIdNullValue();
        this.backupId = BackupRequestEncoder.backupIdNullValue();
        return this;
    }

    public BackupRequestType getType() {
        return this.type;
    }

    public BackupRequest setType(BackupRequestType type) {
        this.type = type;
        return this;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public BackupRequest setPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public long getBackupId() {
        return this.backupId;
    }

    public BackupRequest setBackupId(long backupId) {
        this.backupId = backupId;
        return this;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.bodyDecoder.wrapAndApplyHeader(buffer, offset, this.headerDecoder);
        this.partitionId = this.bodyDecoder.partitionId();
        this.type = this.bodyDecoder.type();
        this.backupId = this.bodyDecoder.backupId();
    }

    public int getLength() {
        return this.headerEncoder.encodedLength() + this.bodyEncoder.sbeBlockLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.bodyEncoder.wrapAndApplyHeader(buffer, offset, this.headerEncoder).partitionId(this.partitionId).type(this.type).backupId(this.backupId);
    }
}

