/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.authorization;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.value.ObjectValue;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.protocol.record.value.AuthorizationRecordValue;
import io.camunda.zeebe.protocol.record.value.PermissionType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.stream.StreamSupport;

@JsonIgnoreProperties(value={"encodedLength", "empty"})
public final class Permission
extends ObjectValue
implements AuthorizationRecordValue.PermissionValue {
    private final EnumProperty<PermissionType> permissionTypeProp = new EnumProperty("permissionType", PermissionType.class);
    private final ArrayProperty<StringValue> resourceIdsProp = new ArrayProperty("resourceIds", StringValue::new);

    public Permission() {
        super(2);
        this.declareProperty((BaseProperty)this.permissionTypeProp).declareProperty(this.resourceIdsProp);
    }

    public Permission copy(AuthorizationRecordValue.PermissionValue object) {
        this.setPermissionType(object.getPermissionType()).addResourceIds(object.getResourceIds());
        return this;
    }

    public PermissionType getPermissionType() {
        return (PermissionType)this.permissionTypeProp.getValue();
    }

    public Permission setPermissionType(PermissionType permissionType) {
        this.permissionTypeProp.setValue((Enum)permissionType);
        return this;
    }

    public List<String> getResourceIds() {
        return StreamSupport.stream(this.resourceIdsProp.spliterator(), false).map(StringValue::getValue).map(BufferUtil::bufferAsString).toList();
    }

    public Permission addResourceIds(List<String> resourceIds) {
        resourceIds.forEach(this::addResourceId);
        return this;
    }

    public Permission addResourceId(String resourceId) {
        ((StringValue)this.resourceIdsProp.add()).wrap(BufferUtil.wrapString((String)resourceId));
        return this;
    }
}

