/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.processinstance;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationStartInstruction;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class ProcessInstanceCreationRecord
extends UnifiedRecordValue
implements ProcessInstanceCreationRecordValue {
    private final StringProperty bpmnProcessIdProperty = new StringProperty("bpmnProcessId", "");
    private final LongProperty processDefinitionKeyProperty = new LongProperty("processDefinitionKey", -1L);
    private final IntegerProperty versionProperty = new IntegerProperty("version", -1);
    private final StringProperty tenantIdProperty = new StringProperty("tenantId", "<default>");
    private final DocumentProperty variablesProperty = new DocumentProperty("variables");
    private final LongProperty processInstanceKeyProperty = new LongProperty("processInstanceKey", -1L);
    private final ArrayProperty<StringValue> fetchVariablesProperty = new ArrayProperty("fetchVariables", StringValue::new);
    private final ArrayProperty<ProcessInstanceCreationStartInstruction> startInstructionsProperty = new ArrayProperty("startInstructions", ProcessInstanceCreationStartInstruction::new);

    public ProcessInstanceCreationRecord() {
        super(8);
        this.declareProperty((BaseProperty)this.bpmnProcessIdProperty).declareProperty((BaseProperty)this.processDefinitionKeyProperty).declareProperty((BaseProperty)this.processInstanceKeyProperty).declareProperty((BaseProperty)this.versionProperty).declareProperty((BaseProperty)this.variablesProperty).declareProperty(this.fetchVariablesProperty).declareProperty(this.startInstructionsProperty).declareProperty((BaseProperty)this.tenantIdProperty);
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProperty.getValue());
    }

    public int getVersion() {
        return this.versionProperty.getValue();
    }

    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProperty.getValue();
    }

    public ProcessInstanceCreationRecord setProcessDefinitionKey(long key) {
        this.processDefinitionKeyProperty.setValue(key);
        return this;
    }

    public List<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> getStartInstructions() {
        return this.startInstructionsProperty.stream().map(element -> {
            ProcessInstanceCreationStartInstruction elementCopy = new ProcessInstanceCreationStartInstruction();
            elementCopy.copy((ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue)element);
            return elementCopy;
        }).toList();
    }

    public ProcessInstanceCreationRecord setVersion(int version) {
        this.versionProperty.setValue(version);
        return this;
    }

    public ProcessInstanceCreationRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProperty.setValue(bpmnProcessId);
        return this;
    }

    public ProcessInstanceCreationRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProperty.setValue(bpmnProcessId);
        return this;
    }

    @JsonIgnore
    public boolean hasStartInstructions() {
        return !this.startInstructionsProperty.isEmpty();
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKeyProperty.getValue();
    }

    public ProcessInstanceCreationRecord setProcessInstanceKey(long instanceKey) {
        this.processInstanceKeyProperty.setValue(instanceKey);
        return this;
    }

    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProperty.getValue());
    }

    public ProcessInstanceCreationRecord setVariables(DirectBuffer variables) {
        this.variablesProperty.setValue(variables);
        return this;
    }

    public ArrayProperty<StringValue> fetchVariables() {
        return this.fetchVariablesProperty;
    }

    public ProcessInstanceCreationRecord setFetchVariables(List<String> fetchVariables) {
        fetchVariables.forEach(variable -> ((StringValue)this.fetchVariablesProperty.add()).wrap(BufferUtil.wrapString((String)variable)));
        return this;
    }

    public ArrayProperty<ProcessInstanceCreationStartInstruction> startInstructions() {
        return this.startInstructionsProperty;
    }

    public ProcessInstanceCreationRecord addStartInstructions(List<ProcessInstanceCreationStartInstruction> startInstructions) {
        startInstructions.forEach(this::addStartInstruction);
        return this;
    }

    public ProcessInstanceCreationRecord addStartInstruction(ProcessInstanceCreationStartInstruction startInstruction) {
        ((ProcessInstanceCreationStartInstruction)this.startInstructionsProperty.add()).copy(startInstruction);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProperty.getValue();
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProperty.getValue();
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProperty.getValue());
    }

    public ProcessInstanceCreationRecord setTenantId(String tenantId) {
        this.tenantIdProperty.setValue(tenantId);
        return this;
    }
}

