/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.job;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BooleanProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.value.LongValue;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class JobBatchRecord
extends UnifiedRecordValue
implements JobBatchRecordValue {
    private final StringProperty typeProp = new StringProperty("type");
    private final StringProperty workerProp = new StringProperty("worker", "");
    private final LongProperty timeoutProp = new LongProperty("timeout", -1L);
    private final IntegerProperty maxJobsToActivateProp = new IntegerProperty("maxJobsToActivate", -1);
    private final ArrayProperty<LongValue> jobKeysProp = new ArrayProperty("jobKeys", LongValue::new);
    private final ArrayProperty<JobRecord> jobsProp = new ArrayProperty("jobs", JobRecord::new);
    private final ArrayProperty<StringValue> tenantIdsProp = new ArrayProperty("tenantIds", StringValue::new);
    private final ArrayProperty<StringValue> variablesProp = new ArrayProperty("variables", StringValue::new);
    private final BooleanProperty truncatedProp = new BooleanProperty("truncated", false);

    public JobBatchRecord() {
        super(9);
        this.declareProperty((BaseProperty)this.typeProp).declareProperty((BaseProperty)this.workerProp).declareProperty((BaseProperty)this.timeoutProp).declareProperty((BaseProperty)this.maxJobsToActivateProp).declareProperty(this.jobKeysProp).declareProperty(this.jobsProp).declareProperty(this.variablesProp).declareProperty((BaseProperty)this.truncatedProp).declareProperty(this.tenantIdsProp);
    }

    public JobBatchRecord setType(DirectBuffer buf, int offset, int length) {
        this.typeProp.setValue(buf, offset, length);
        return this;
    }

    public JobBatchRecord setWorker(DirectBuffer worker, int offset, int length) {
        this.workerProp.setValue(worker, offset, length);
        return this;
    }

    public ValueArray<LongValue> jobKeys() {
        return this.jobKeysProp;
    }

    public ValueArray<JobRecord> jobs() {
        return this.jobsProp;
    }

    public ValueArray<StringValue> variables() {
        return this.variablesProp;
    }

    public boolean getTruncated() {
        return this.truncatedProp.getValue();
    }

    public String getType() {
        return BufferUtil.bufferAsString((DirectBuffer)this.typeProp.getValue());
    }

    public String getWorker() {
        return BufferUtil.bufferAsString((DirectBuffer)this.workerProp.getValue());
    }

    public long getTimeout() {
        return this.timeoutProp.getValue();
    }

    public int getMaxJobsToActivate() {
        return this.maxJobsToActivateProp.getValue();
    }

    public List<Long> getJobKeys() {
        return StreamSupport.stream(this.jobKeysProp.spliterator(), false).map(LongValue::getValue).collect(Collectors.toList());
    }

    public List<JobRecordValue> getJobs() {
        return StreamSupport.stream(this.jobsProp.spliterator(), false).map(jobRecord -> {
            byte[] bytes = new byte[jobRecord.getLength()];
            UnsafeBuffer copyRecord = new UnsafeBuffer(bytes);
            JobRecord copiedRecord = new JobRecord();
            jobRecord.write((MutableDirectBuffer)copyRecord, 0);
            copiedRecord.wrap((DirectBuffer)copyRecord);
            return copiedRecord;
        }).collect(Collectors.toList());
    }

    public boolean isTruncated() {
        return this.truncatedProp.getValue();
    }

    public List<String> getTenantIds() {
        return StreamSupport.stream(this.tenantIdsProp.spliterator(), false).map(StringValue::getValue).map(BufferUtil::bufferAsString).collect(Collectors.toList());
    }

    public JobBatchRecord setTenantIds(List<String> tenantIds) {
        this.tenantIdsProp.reset();
        tenantIds.forEach(tenantId -> ((StringValue)this.tenantIdsProp.add()).wrap(BufferUtil.wrapString((String)tenantId)));
        return this;
    }

    public JobBatchRecord setTruncated(boolean truncated) {
        this.truncatedProp.setValue(truncated);
        return this;
    }

    public JobBatchRecord setMaxJobsToActivate(int maxJobsToActivate) {
        this.maxJobsToActivateProp.setValue(maxJobsToActivate);
        return this;
    }

    public JobBatchRecord setTimeout(long val) {
        this.timeoutProp.setValue(val);
        return this;
    }

    public JobBatchRecord setWorker(DirectBuffer worker) {
        this.workerProp.setValue(worker);
        return this;
    }

    public JobBatchRecord setWorker(String worker) {
        this.workerProp.setValue(worker);
        return this;
    }

    public JobBatchRecord setType(DirectBuffer buf) {
        this.typeProp.setValue(buf);
        return this;
    }

    public JobBatchRecord setType(String type) {
        this.typeProp.setValue(type);
        return this;
    }

    public ValueArray<StringValue> tenantIds() {
        return this.tenantIdsProp;
    }

    @JsonIgnore
    public DirectBuffer getTypeBuffer() {
        return this.typeProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getWorkerBuffer() {
        return this.workerProp.getValue();
    }
}

