/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.deployment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormMetadataRecord;
import io.camunda.zeebe.protocol.record.value.deployment.Form;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class FormRecord
extends UnifiedRecordValue
implements Form {
    private final StringProperty formIdProp = new StringProperty("formId");
    private final IntegerProperty versionProp = new IntegerProperty("version");
    private final LongProperty formKeyProp = new LongProperty("formKey");
    private final StringProperty resourceNameProp = new StringProperty("resourceName");
    private final BinaryProperty checksumProp = new BinaryProperty("checksum", (DirectBuffer)new UnsafeBuffer());
    private final BinaryProperty resourceProp = new BinaryProperty("resource", (DirectBuffer)new UnsafeBuffer());
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");

    public FormRecord() {
        super(7);
        this.declareProperty((BaseProperty)this.formIdProp).declareProperty((BaseProperty)this.versionProp).declareProperty((BaseProperty)this.formKeyProp).declareProperty((BaseProperty)this.resourceNameProp).declareProperty((BaseProperty)this.checksumProp).declareProperty((BaseProperty)this.resourceProp).declareProperty((BaseProperty)this.tenantIdProp);
    }

    public FormRecord wrap(FormMetadataRecord metadata, byte[] resource) {
        this.formIdProp.setValue(metadata.getFormId());
        this.versionProp.setValue(metadata.getVersion());
        this.checksumProp.setValue(metadata.getChecksumBuffer());
        this.formKeyProp.setValue(metadata.getFormKey());
        this.resourceNameProp.setValue(metadata.getResourceNameBuffer());
        this.resourceProp.setValue((DirectBuffer)BufferUtil.wrapArray((byte[])resource));
        this.tenantIdProp.setValue(metadata.getTenantId());
        return this;
    }

    public String getFormId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.formIdProp.getValue());
    }

    public FormRecord setFormId(String formId) {
        this.formIdProp.setValue(formId);
        return this;
    }

    public FormRecord setFormId(DirectBuffer formId) {
        this.formIdProp.setValue(formId);
        return this;
    }

    public int getVersion() {
        return this.versionProp.getValue();
    }

    public FormRecord setVersion(int version) {
        this.versionProp.setValue(version);
        return this;
    }

    public long getFormKey() {
        return this.formKeyProp.getValue();
    }

    public FormRecord setFormKey(long key) {
        this.formKeyProp.setValue(key);
        return this;
    }

    public String getResourceName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.resourceNameProp.getValue());
    }

    public FormRecord setResourceName(String resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public FormRecord setResourceName(DirectBuffer resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public byte[] getChecksum() {
        return BufferUtil.bufferAsArray((DirectBuffer)this.checksumProp.getValue());
    }

    public FormRecord setChecksum(DirectBuffer checksumBuffer) {
        this.checksumProp.setValue(checksumBuffer);
        return this;
    }

    public boolean isDuplicate() {
        return false;
    }

    @JsonIgnore
    public DirectBuffer getChecksumBuffer() {
        return this.checksumProp.getValue();
    }

    public byte[] getResource() {
        return BufferUtil.bufferAsArray((DirectBuffer)this.resourceProp.getValue());
    }

    public FormRecord setResource(DirectBuffer resource) {
        return this.setResource(resource, 0, resource.capacity());
    }

    @JsonIgnore
    public DirectBuffer getFormIdBuffer() {
        return this.formIdProp.getValue();
    }

    @Override
    @JsonIgnore
    public int getLength() {
        return super.getLength();
    }

    @Override
    @JsonIgnore
    public int getEncodedLength() {
        return super.getEncodedLength();
    }

    @JsonIgnore
    public DirectBuffer getResourceNameBuffer() {
        return this.resourceNameProp.getValue();
    }

    public FormRecord setFormId(DirectBuffer formId, int offset, int length) {
        this.formIdProp.setValue(formId, offset, length);
        return this;
    }

    public FormRecord setResource(DirectBuffer resource, int offset, int length) {
        this.resourceProp.setValue(resource, offset, length);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getResourceBuffer() {
        return this.resourceProp.getValue();
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProp.getValue());
    }

    public FormRecord setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }
}

