/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.request;

import io.camunda.zeebe.broker.client.api.RequestDispatchStrategy;
import io.camunda.zeebe.broker.client.api.dto.BrokerExecuteCommand;
import io.camunda.zeebe.gateway.impl.broker.PublishMessageDispatchStrategy;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageCorrelationRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageCorrelationIntent;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Optional;
import org.agrona.DirectBuffer;

public final class BrokerCorrelateMessageRequest
extends BrokerExecuteCommand<MessageCorrelationRecord> {
    private final MessageCorrelationRecord requestDto = new MessageCorrelationRecord();
    private final PublishMessageDispatchStrategy dispatchStrategy;

    public BrokerCorrelateMessageRequest(String messageName, String correlationKey) {
        super(ValueType.MESSAGE_CORRELATION, (Intent)MessageCorrelationIntent.CORRELATE);
        this.requestDto.setName(messageName).setCorrelationKey(correlationKey);
        this.dispatchStrategy = new PublishMessageDispatchStrategy(correlationKey);
    }

    public BrokerCorrelateMessageRequest setVariables(DirectBuffer variables) {
        this.requestDto.setVariables(variables);
        return this;
    }

    public BrokerCorrelateMessageRequest setTenantId(String tenantId) {
        this.requestDto.setTenantId(tenantId);
        return this;
    }

    public BufferWriter getRequestWriter() {
        return this.requestDto;
    }

    protected MessageCorrelationRecord toResponseDto(DirectBuffer buffer) {
        MessageCorrelationRecord responseDto = new MessageCorrelationRecord();
        responseDto.wrap(buffer);
        return responseDto;
    }

    public Optional<RequestDispatchStrategy> requestDispatchStrategy() {
        return Optional.of(this.dispatchStrategy);
    }
}

