/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.configuration;

import io.atomix.utils.net.Address;
import io.camunda.zeebe.gateway.impl.configuration.ClusterCfg;
import io.camunda.zeebe.gateway.impl.configuration.FilterCfg;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.gateway.impl.configuration.InterceptorCfg;
import io.camunda.zeebe.gateway.impl.configuration.MembershipCfg;
import io.camunda.zeebe.test.util.TestConfigurationFactory;
import io.camunda.zeebe.util.Environment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public final class GatewayCfgTest {
    private static final String DEFAULT_CFG_FILENAME = "/configuration/gateway.default.yaml";
    private static final GatewayCfg DEFAULT_CFG = new GatewayCfg();
    private static final String EMPTY_CFG_FILENAME = "/configuration/gateway.empty.yaml";
    private static final String CUSTOM_CFG_FILENAME = "/configuration/gateway.custom.yaml";
    private static final GatewayCfg CUSTOM_CFG = new GatewayCfg();
    private static final String CUSTOM_MEMBERSHIP_CFG_FILENAME = "/configuration/gateway.membership.custom.yaml";
    private final Map<String, String> environment = new HashMap<String, String>();

    @Test
    public void shouldHaveDefaultValues() {
        GatewayCfg gatewayCfg = this.readDefaultConfig();
        Assertions.assertThat((Object)gatewayCfg).isEqualTo((Object)DEFAULT_CFG);
    }

    @Test
    public void shouldLoadEmptyConfig() {
        GatewayCfg gatewayCfg = this.readEmptyConfig();
        Assertions.assertThat((Object)gatewayCfg).isEqualTo((Object)DEFAULT_CFG);
    }

    @Test
    public void shouldLoadCustomConfig() {
        GatewayCfg gatewayCfg = this.readCustomConfig();
        Assertions.assertThat((Object)gatewayCfg).isEqualTo((Object)CUSTOM_CFG);
    }

    @Test
    public void shouldSetCustomMembershipConfig() {
        GatewayCfg gatewayCfg = this.readConfig(CUSTOM_MEMBERSHIP_CFG_FILENAME);
        MembershipCfg membershipCfg = gatewayCfg.getCluster().getMembership();
        Assertions.assertThat((boolean)membershipCfg.isBroadcastDisputes()).isFalse();
        Assertions.assertThat((boolean)membershipCfg.isBroadcastUpdates()).isTrue();
        Assertions.assertThat((boolean)membershipCfg.isNotifySuspect()).isTrue();
        Assertions.assertThat((Duration)membershipCfg.getGossipInterval()).isEqualTo((Object)Duration.ofSeconds(2L));
        Assertions.assertThat((int)membershipCfg.getGossipFanout()).isEqualTo(3);
        Assertions.assertThat((Duration)membershipCfg.getProbeInterval()).isEqualTo((Object)Duration.ofSeconds(3L));
        Assertions.assertThat((Duration)membershipCfg.getProbeTimeout()).isEqualTo((Object)Duration.ofSeconds(5L));
        Assertions.assertThat((int)membershipCfg.getSuspectProbes()).isEqualTo(5);
        Assertions.assertThat((Duration)membershipCfg.getFailureTimeout()).isEqualTo((Object)Duration.ofSeconds(20L));
        Assertions.assertThat((Duration)membershipCfg.getSyncInterval()).isEqualTo((Object)Duration.ofSeconds(25L));
    }

    @Test
    public void shouldUseEnvironmentVariables() {
        this.setEnv("zeebe.gateway.network.host", "zeebe");
        this.setEnv("zeebe.gateway.network.port", "5432");
        this.setEnv("zeebe.gateway.cluster.initialContactPoints", "broker:432,anotherBroker:789");
        this.setEnv("zeebe.gateway.threads.managementThreads", "32");
        this.setEnv("zeebe.gateway.cluster.requestTimeout", Duration.ofMinutes(43L).toString());
        this.setEnv("zeebe.gateway.cluster.longPollingEnabled", "false");
        this.setEnv("zeebe.gateway.cluster.clusterName", "envCluster");
        this.setEnv("zeebe.gateway.cluster.memberId", "envMember");
        this.setEnv("zeebe.gateway.cluster.host", "envHost");
        this.setEnv("zeebe.gateway.cluster.port", "12345");
        this.setEnv("zeebe.gateway.security.enabled", String.valueOf(false));
        this.setEnv("zeebe.gateway.security.privateKeyPath", GatewayCfgTest.class.getClassLoader().getResource("security/test-server.key.pem").getPath());
        this.setEnv("zeebe.gateway.security.certificateChainPath", GatewayCfgTest.class.getClassLoader().getResource("security/test-chain.cert.pem").getPath());
        this.setEnv("zeebe.gateway.network.minKeepAliveInterval", Duration.ofSeconds(30L).toString());
        this.setEnv("zeebe.gateway.longPolling.enabled", String.valueOf(true));
        this.setEnv("zeebe.gateway.multiTenancy.enabled", String.valueOf(false));
        this.setEnv("zeebe.gateway.interceptors.0.id", "overwritten");
        this.setEnv("zeebe.gateway.interceptors.0.className", "Overwritten");
        this.setEnv("zeebe.gateway.interceptors.0.jarPath", "./overwritten.jar");
        this.setEnv("zeebe.gateway.filters.0.id", "overwrittenFilter");
        this.setEnv("zeebe.gateway.filters.0.className", "OverwrittenFilter");
        this.setEnv("zeebe.gateway.filters.0.jarPath", "./overwrittenFilter.jar");
        GatewayCfg expected = new GatewayCfg();
        expected.getNetwork().setHost("zeebe").setPort(5432).setMinKeepAliveInterval(Duration.ofSeconds(30L));
        expected.getCluster().setInitialContactPoints(List.of("broker:432", "anotherBroker:789")).setRequestTimeout(Duration.ofMinutes(43L)).setClusterName("envCluster").setMemberId("envMember").setHost("envHost").setPort(12345);
        expected.getThreads().setManagementThreads(32);
        expected.getSecurity().setEnabled(false).setPrivateKeyPath(new File(this.getClass().getClassLoader().getResource("security/test-server.key.pem").getPath())).setCertificateChainPath(new File(this.getClass().getClassLoader().getResource("security/test-chain.cert.pem").getPath()));
        expected.getLongPolling().setEnabled(true);
        expected.getMultiTenancy().setEnabled(false);
        expected.getInterceptors().add(new InterceptorCfg());
        ((InterceptorCfg)expected.getInterceptors().get(0)).setId("overwritten");
        ((InterceptorCfg)expected.getInterceptors().get(0)).setClassName("Overwritten");
        ((InterceptorCfg)expected.getInterceptors().get(0)).setJarPath("./overwritten.jar");
        expected.getFilters().add(new FilterCfg());
        ((FilterCfg)expected.getFilters().get(0)).setId("overwrittenFilter");
        ((FilterCfg)expected.getFilters().get(0)).setClassName("OverwrittenFilter");
        ((FilterCfg)expected.getFilters().get(0)).setJarPath("./overwrittenFilter.jar");
        GatewayCfg gatewayCfg = this.readCustomConfig();
        Assertions.assertThat((Object)gatewayCfg).isEqualTo((Object)expected);
    }

    @Test
    public void shouldSetInitialContactPointsWhenSetContactPoint() {
        String contactPoint = "foo-bar:1";
        GatewayCfg gatewayCfg = new GatewayCfg().setCluster(new ClusterCfg().setContactPoint("foo-bar:1"));
        Assertions.assertThat((List)gatewayCfg.getCluster().getInitialContactPoints()).containsExactly((Object[])new String[]{"foo-bar:1"});
    }

    @Test
    public void shouldSetInitialContactPointsWhenUseContactPointEnvironmentVariable() {
        String contactPoint = "broker:789";
        this.setEnv("zeebe.gateway.cluster.contactPoint", "broker:789");
        GatewayCfg expected = new GatewayCfg().setCluster(new ClusterCfg().setInitialContactPoints(List.of("broker:789")));
        expected.init();
        GatewayCfg gatewayCfg = this.readDefaultConfig();
        Assertions.assertThat((Object)gatewayCfg).isEqualTo((Object)expected);
    }

    @Test
    public void shouldSetInitialContactPointsWhenUseContactPointConfig() {
        String contactPoint = "broker:789";
        GatewayCfg expected = new GatewayCfg().setCluster(new ClusterCfg().setInitialContactPoints(List.of("broker:789")));
        expected.init();
        GatewayCfg gatewayCfg = this.readConfig("/configuration/gateway.deprecated.contactPoint.custom.yaml");
        Assertions.assertThat((Object)gatewayCfg).isEqualTo((Object)expected);
    }

    @Test
    public void shouldFallbackIfAdvertisedAddressIsNotConfigured() {
        String expectedHost = "zeebe";
        String expectedPort = "5432";
        this.setEnv("zeebe.gateway.cluster.host", "zeebe");
        this.setEnv("zeebe.gateway.cluster.port", "5432");
        GatewayCfg actual = this.readEmptyConfig();
        Assertions.assertThat((String)actual.getCluster().getAdvertisedHost()).isEqualTo("zeebe");
        Assertions.assertThat((int)actual.getCluster().getAdvertisedPort()).isEqualTo(Integer.parseInt("5432"));
    }

    @Test
    public void shouldUseFirstNonLoopBackAdvertisedAddressIfNothingSet() {
        String expectedHost = Address.defaultAdvertisedHost().getHostAddress();
        String expectedPort = "5432";
        this.setEnv("zeebe.gateway.cluster.host", null);
        this.setEnv("zeebe.gateway.cluster.port", "5432");
        GatewayCfg actual = this.readEmptyConfig();
        Assertions.assertThat((String)actual.getCluster().getAdvertisedHost()).isEqualTo(expectedHost);
        Assertions.assertThat((int)actual.getCluster().getAdvertisedPort()).isEqualTo(Integer.parseInt("5432"));
    }

    private void setEnv(String key, String value) {
        this.environment.put(key, value);
    }

    private GatewayCfg readDefaultConfig() {
        return this.readConfig(DEFAULT_CFG_FILENAME);
    }

    private GatewayCfg readEmptyConfig() {
        return this.readConfig(EMPTY_CFG_FILENAME);
    }

    private GatewayCfg readCustomConfig() {
        return this.readConfig(CUSTOM_CFG_FILENAME);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GatewayCfg readConfig(String filename) {
        try (InputStream inputStream = GatewayCfgTest.class.getResourceAsStream(filename);){
            if (inputStream == null) throw new AssertionError((Object)("Unable to find configuration file: " + filename));
            GatewayCfg gatewayCfg2 = (GatewayCfg)new TestConfigurationFactory().create(new Environment(this.environment), "zeebe.gateway", filename, GatewayCfg.class);
            gatewayCfg2.init();
            GatewayCfg gatewayCfg = gatewayCfg2;
            return gatewayCfg;
        }
        catch (IOException e) {
            throw new AssertionError("Failed to read configuration from file: " + filename, e);
        }
    }

    static {
        DEFAULT_CFG.init();
        CUSTOM_CFG.init();
        CUSTOM_CFG.getNetwork().setHost("192.168.0.1").setPort(123);
        CUSTOM_CFG.getCluster().setInitialContactPoints(List.of("foobar:1234", "barfoo:5678")).setRequestTimeout(Duration.ofHours(123L)).setClusterName("testCluster").setMemberId("testMember").setHost("1.2.3.4").setPort(12321);
        CUSTOM_CFG.getSecurity().setEnabled(true).setCertificateChainPath(new File("certificateChainPath")).setPrivateKeyPath(new File("privateKeyPath"));
        CUSTOM_CFG.getThreads().setManagementThreads(100);
        CUSTOM_CFG.getLongPolling().setEnabled(false);
        CUSTOM_CFG.getMultiTenancy().setEnabled(true);
        CUSTOM_CFG.getInterceptors().add(new InterceptorCfg());
        ((InterceptorCfg)CUSTOM_CFG.getInterceptors().get(0)).setId("example");
        ((InterceptorCfg)CUSTOM_CFG.getInterceptors().get(0)).setClassName("io.camunda.zeebe.example.Interceptor");
        ((InterceptorCfg)CUSTOM_CFG.getInterceptors().get(0)).setJarPath("./interceptor.jar");
        CUSTOM_CFG.getInterceptors().add(new InterceptorCfg());
        ((InterceptorCfg)CUSTOM_CFG.getInterceptors().get(1)).setId("example2");
        ((InterceptorCfg)CUSTOM_CFG.getInterceptors().get(1)).setClassName("io.camunda.zeebe.example.Interceptor2");
        ((InterceptorCfg)CUSTOM_CFG.getInterceptors().get(1)).setJarPath("./interceptor2.jar");
        CUSTOM_CFG.getFilters().add(new FilterCfg());
        ((FilterCfg)CUSTOM_CFG.getFilters().get(0)).setId("filterExample");
        ((FilterCfg)CUSTOM_CFG.getFilters().get(0)).setClassName("io.camunda.zeebe.example.Filter");
        ((FilterCfg)CUSTOM_CFG.getFilters().get(0)).setJarPath("./filter.jar");
        CUSTOM_CFG.getFilters().add(new FilterCfg());
        ((FilterCfg)CUSTOM_CFG.getFilters().get(1)).setId("filterExample2");
        ((FilterCfg)CUSTOM_CFG.getFilters().get(1)).setClassName("io.camunda.zeebe.example.Filter2");
        ((FilterCfg)CUSTOM_CFG.getFilters().get(1)).setJarPath("./filter2.jar");
    }
}

